package com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataAnalysisFluctuateQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.BulletinRequest;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AgileDataAutoDataQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜敏捷Echo服务调用类</p>
 *
 * @author wuyang
 */
public interface DigiwinAgileDataEchoProxyService {

    String API_PREFIX = "/api/ai/agile/echo";

    /**
     * 查询已读公告列表
     *
     * @param apiRequest
     * @return
     */
    List<EchoGmcBulletinResultDTO> queryReadBulletinList(ApiRequest apiRequest);

    /**
     * 查询未读公告列表
     *
     * @param apiRequest
     * @return
     */
    EchoGmcBulletinUnReadResultDTO queryUnreadBulletinList(ApiRequest apiRequest);

    /**
     * 保存已读公告
     *
     * @param request
     * @return
     */
    Boolean saveReadBulletin(BulletinRequest request);

    /**
     * 获取敏捷数据流量控制弹窗预警阈值
     *
     * @param queryDTO
     * @return
     */
    List<EchoInformationModel> getExceptionInfoByMessageId(EchoInformationModelQueryDTO queryDTO);

    /**
     * 敏捷数据：获取异常信息:场景排查和要素解析
     *
     * @param queryDTO
     * @return
     * @Link <a href="http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#66ab4d33d3ffa8000b47a2c4">...</a>
     */
    Map<String, Object> getInfoAndSchemaByMessageId(EchoInformationModelQueryDTO queryDTO);

    /**
     * 敏捷数据：查询产品公告配置列表
     *
     * @param queryDTO
     * @return
     */
    List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(EchoPageConfigProductBulletinQueryDTO queryDTO);

    /**
     * 敏捷数据：查询开场白配置
     *
     * @param queryDTO
     * @return
     */
    EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(EchoPageConfigProductBulletinQueryDTO queryDTO);

    /**
     * 查询移动端角色配置列表
     *
     * @param queryDTO
     * @return
     */
    List<EchoExperienceRoleConfigDataResultDTO> queryExperienceRoleConfigList(EchoExperienceRoleConfigDataQueryDTO queryDTO);

    /**
     * Lite版查询移动端上传限制说明配置
     *
     * @param apiRequest
     * @return
     */
    EchoLiteUploadLimitationsConfigDataResultDTO queryLiteUploadLimitationsConfig(ApiRequest apiRequest);

    /**
     * 查询敏捷数据问题排查提效数据列表
     *
     * @param apiRequest
     * @return
     */
    List<EchoMetricCheckMongoDataResultDTO> getMongoDbMetricInfoList(ApiRequest apiRequest);

    /**
     * 查询敏捷数据新指标指令集列表
     *
     * @param apiRequest
     * @return
     */
    List<EchoInstructionGroupResultDTO> queryCommandIntentions(ApiRequest apiRequest);

    /**
     * 查询敏捷数据引导提问模糊匹配配置
     *
     * @param apiRequest
     * @return
     */
    EchoFuzzyMatchingConfigDataResultDTO queryFuzzyMatchingConfig(ApiRequest apiRequest);

    /**
     * 保存用户习惯(比如追问开关)
     *
     * @param request
     * @return
     */
    Boolean saveUserHabitual(EchoUserDefineHabitualDTO request);

    /**
     * 获取用户习惯(比如追问开关)
     *
     * @param request
     * @return
     */
    EchoAgileDataUserDefine getUserHabitual(AgileDataApiRequest request);

    /**
     * 图表转换
     *
     * @param request
     * @return
     */
    EchoConvertChartResultData convertChartDataset(AgileDataApiRequest request);

    /**
     * 获取敏捷数据Dsl
     *
     * @param request
     * @return
     */
    AgileDataIntermediateDsl getAgileDataDsl(AgileDataApiRequest request);

    /**
     * 获取条件筛选后的DSL
     * @param request
     * @return
     */
    EchoFilterData getFilterAgileData(AgileDataFilterQueryDTO request);

    /**
     * 归因分析-数据波动
     * @param request
     * @return
     */
    EchoAnalysisDataSummaryResultDTO getAttributionAnalysis(AgileDataAnalysisFluctuateQueryDTO request);

    /**
     *归因分析-获取维度归因信息
     * @param request
     * @return
     */
    EchoAnalysisDataDimensionResultDTO getAnalysisDataDimension(AgileDataAnalysisFluctuateQueryDTO request);

    /**
     * auto分析师-获取报告状态
     * @param request
     * @return
     */
    AgileDataEchoAutoDataReportResultDTO getAutoDataReportStatus(AgileDataAutoDataQueryDTO request);
}