package com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.impl;

import com.digiwin.mobile.mobileuibot.agileData.constant.AgileDataConstant;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt.EchoAgileDataFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyPptService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * @date 2025/8/21
 * @author yanfeng
 */
@Slf4j
@Service("digiwinAgileDataEchoProxyPptService")
public class DigiwinAgileDataEchoProxyPptServiceImpl implements DigiwinAgileDataEchoProxyPptService {

    @Autowired
    private HttpService httpService;

    @Override
    public EchoAgileDataFileDTO getAgileDataFile(AgileDataEchoPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyPptService.API_PREFIX
                + "getAgileDataFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAgileDataFileDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAgileDataFileDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoAgileDataFileDTO>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("getAgileDataFile接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return new EchoAgileDataFileDTO();
            }
            if (null != responseEntity.getBody()) {
                return JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse()), EchoAgileDataFileDTO.class);
            }
        } catch (Exception e) {
            log.error("getAgileDataFile接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return new EchoAgileDataFileDTO();
    }

    @Override
    public Boolean saveAgileDataFile(EchoAgileDataFileDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyPptService.API_PREFIX
                + "addAgileDataFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("saveAgileDataFile接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return false;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("saveAgileDataFile接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return false;
    }

    @Override
    public Boolean updateAgileDataFile(EchoAgileDataFileDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyPptService.API_PREFIX
                + "updateAgileDataFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("updateAgileDataFile接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return false;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("updateAgileDataFile接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return false;
    }

    @Override
    public Boolean deleteAgileDataFile(AgileDataEchoPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyPptService.API_PREFIX
                + "deleteAgileDataFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("deleteAgileDataFile接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return false;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("deleteAgileDataFile接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return false;
    }

}