package com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataAnalysisFluctuateQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.BulletinRequest;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AgileDataAutoDataQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.*;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author yanfeng
 * @date 2024/7/24
 */
@Slf4j
@Service("digiwinAgileDataEchoProxyService")
public class DigiwinAgileDataEchoProxyServiceImpl implements DigiwinAgileDataEchoProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public List<EchoGmcBulletinResultDTO> queryReadBulletinList(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/gmc/queryReadBulletinList?pageNum=" + apiRequest.getPageNum() + "&pageSize=" + apiRequest.getPageSize();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoGmcBulletinResultDTO>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoGmcBulletinResultDTO>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<EchoGmcBulletinResultDTO>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
            return responseEntity.getBody().getResponse();
        } else {
            log.error("获取已读公告,queryReadBulletinList异常");
        }
        return null;
    }

    @Override
    public EchoGmcBulletinUnReadResultDTO queryUnreadBulletinList(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/gmc/queryUnreadBulletinList?pageNum=" + apiRequest.getPageNum() + "&pageSize=" + apiRequest.getPageSize();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoGmcBulletinUnReadResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoGmcBulletinUnReadResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoGmcBulletinUnReadResultDTO>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
            return responseEntity.getBody().getResponse();
        } else {
            log.error("获取未读公告,queryUnreadBulletinList异常");
        }
        return null;
    }

    @Override
    public Boolean saveReadBulletin(BulletinRequest request) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/gmc/saveReadBulletin";
        Map<String, Object> params = new HashMap<>();
        params.put("sidList", request.getSidList());

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return null != responseEntity.getBody() && !ObjectUtils.isEmpty(responseEntity.getBody().getResponse());
        } else {
            log.error("保存公告,saveReadBulletin异常");
        }
        return false;
    }

    @Override
    public List<EchoInformationModel> getExceptionInfoByMessageId(EchoInformationModelQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/exception/mongo/get/" + queryDTO.getMessageId();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoInformationModel>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoInformationModel>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<EchoInformationModel>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", queryDTO.getLocale(), queryDTO.getIamUserToken(), queryDTO.getTenantId()), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
            return responseEntity.getBody().getResponse();
        } else {
            log.error("getExceptionInfoByMessageId接口调用失败, url:{} \n request:{} \n responseEntity:{}", url, JsonUtil.javaObjectToJsonString(queryDTO), JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getInfoAndSchemaByMessageId(EchoInformationModelQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/schema/getInfoAndSchema/" + queryDTO.getMessageId();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", queryDTO.getLocale(), queryDTO.getIamUserToken(), queryDTO.getTenantId()), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("getInfoAndSchemaByMessageId接口调用失败, url:{} " +
                            "\n request:{} " +
                            "\n responseEntity:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(queryDTO),
                    JsonUtil.javaObjectToJsonString(responseEntity));
            return null;
        }
        if (null == responseEntity.getBody()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(EchoPageConfigProductBulletinQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX + "/page/config/queryProductBulletinList";
        Map<String, String> map = new HashMap<>(2);
        map.put("assistantName", queryDTO.getAssistantName());
        map.put("source", "MOBILE");
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoPageConfigProductBulletinResultDTO>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoPageConfigProductBulletinResultDTO>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<EchoPageConfigProductBulletinResultDTO>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", queryDTO.getLocale(), queryDTO.getIamUserToken(), queryDTO.getTenantId())
                        , JsonUtil.javaObjectToJsonString(map), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("queryProductBulletinList接口调用失败, url:{} " +
                            "\n request:{} " +
                            "\n responseEntity:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(queryDTO),
                    JsonUtil.javaObjectToJsonString(responseEntity));
            return null;
        }
        if (null == responseEntity.getBody()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(EchoPageConfigProductBulletinQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX + "/page/config/queryOpeningRemarksConfig";
        Map<String, String> map = new HashMap<>(2);
        map.put("assistantName", queryDTO.getAssistantName());
        map.put("source", queryDTO.getSource());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoOpeningRemarksConfigResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoOpeningRemarksConfigResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoOpeningRemarksConfigResultDTO>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", queryDTO.getLocale(), queryDTO.getIamUserToken(), queryDTO.getTenantId())
                        , JsonUtil.javaObjectToJsonString(map), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("queryOpeningRemarksConfig接口调用失败, url:{} " +
                            "\n request:{} " +
                            "\n responseEntity:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(queryDTO),
                    JsonUtil.javaObjectToJsonString(responseEntity));
            return null;
        }
        if (null == responseEntity.getBody()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<EchoExperienceRoleConfigDataResultDTO> queryExperienceRoleConfigList(EchoExperienceRoleConfigDataQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX + "/page/config/queryExperienceRoleConfigList";
        Map<String, String> map = new HashMap<>(2);
        map.put("district", queryDTO.getDistrict());
        map.put("locale", queryDTO.getLocale());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoExperienceRoleConfigDataResultDTO>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoExperienceRoleConfigDataResultDTO>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<EchoExperienceRoleConfigDataResultDTO>>> responseEntity = null;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead()
                    , JsonUtil.javaObjectToJsonString(map), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("queryExperienceRoleConfigList接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(queryDTO),
                        JsonUtil.javaObjectToJsonString(responseEntity));
                return null;
            }
            if (null == responseEntity.getBody()) {
                return Collections.emptyList();
            }
            return responseEntity.getBody().getResponse();
        } catch (Exception e) {
            log.error("queryExperienceRoleConfigList接口调用异常, url:{} " +
                            "\n request:{} " +
                            "\n error:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(queryDTO),
                    e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    @Override
    public EchoLiteUploadLimitationsConfigDataResultDTO queryLiteUploadLimitationsConfig(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX + "/page/config/queryLiteUploadLimitationsConfig";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoLiteUploadLimitationsConfigDataResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoLiteUploadLimitationsConfigDataResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoLiteUploadLimitationsConfigDataResultDTO>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId())
                        , JsonUtil.javaObjectToJsonString(new HashMap<>(2)), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("queryLiteUploadLimitationsConfig接口调用失败, url:{} " +
                            "\n request:{} " +
                            "\n responseEntity:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(apiRequest),
                    JsonUtil.javaObjectToJsonString(responseEntity));
            return null;
        }
        if (null == responseEntity.getBody()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<EchoMetricCheckMongoDataResultDTO> getMongoDbMetricInfoList(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/exception/mongo/metric/get/" + apiRequest.getDataId();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoMetricCheckMongoDataResultDTO>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoMetricCheckMongoDataResultDTO>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<EchoMetricCheckMongoDataResultDTO>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("getMongoDbMetricInfoByMessageId接口调用失败, url:{} " +
                            "\n request:{} " +
                            "\n responseEntity:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(apiRequest),
                    JsonUtil.javaObjectToJsonString(responseEntity));
            return null;
        }
        if (null == responseEntity.getBody()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<EchoInstructionGroupResultDTO> queryCommandIntentions(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/page/config/queryCommandIntentions";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoInstructionGroupResultDTO>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<EchoInstructionGroupResultDTO>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<EchoInstructionGroupResultDTO>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("queryCommandIntentions接口调用失败, url:{} " +
                            "\n request:{} " +
                            "\n responseEntity:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(apiRequest),
                    JsonUtil.javaObjectToJsonString(responseEntity));
            return null;
        }
        if (null == responseEntity.getBody()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public EchoFuzzyMatchingConfigDataResultDTO queryFuzzyMatchingConfig(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX + "/page/config/queryFuzzyMatchingConfig";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoFuzzyMatchingConfigDataResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoFuzzyMatchingConfigDataResultDTO>>() {
                };
        try {
            ResponseEntity<DigiwinAthenaApiResponse<EchoFuzzyMatchingConfigDataResultDTO>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId())
                            , JsonUtil.javaObjectToJsonString(new HashMap<>(2)), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("queryFuzzyMatchingConfig接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(apiRequest),
                        JsonUtil.javaObjectToJsonString(responseEntity));
                return null;
            }
            if (null == responseEntity.getBody()) {
                return null;
            }
            return responseEntity.getBody().getResponse();
        } catch (Exception e) {
            log.error("queryFuzzyMatchingConfig接口调用异常:{} ", e.getMessage());
        }
        return null;
    }

    @Override
    public Boolean saveUserHabitual(EchoUserDefineHabitualDTO apiRequest) {
        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                null;
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/habit/user/save";

        Map<String, Boolean> map = new HashMap<>(1);
        map.put("probe", apiRequest.getProbe());

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequest.getLocale(),
                    apiRequest.getIamUserToken(), apiRequest.getTenantId()), JsonUtil.javaObjectToJsonString(map), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("saveUserHabitual接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(apiRequest),
                        JsonUtil.javaObjectToJsonString(responseEntity));
                return false;
            }
        } catch (Exception e) {
            log.error("saveUserHabitual接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(apiRequest));
        }
        if (responseEntity != null && null != responseEntity.getBody()) {
            return responseEntity.getBody().getResponse();
        }
        return false;
    }

    @Override
    public EchoAgileDataUserDefine getUserHabitual(AgileDataApiRequest apiRequest) {
        ResponseEntity<DigiwinAthenaApiResponse<EchoAgileDataUserDefine>> responseEntity =
                null;
        String url = AppContext.getApiUrlSetting().getEchoUrl() + DigiwinAgileDataEchoProxyService.API_PREFIX
                + "/habit/user/get";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAgileDataUserDefine>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAgileDataUserDefine>>() {
                };
        try {
            responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequest.getLocale(),
                    apiRequest.getIamUserToken(), apiRequest.getTenantId()), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getUserHabitual接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(apiRequest),
                        JsonUtil.javaObjectToJsonString(responseEntity));
                return null;
            }
        } catch (Exception e) {
            log.error("getUserHabitual接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(apiRequest));
        }
        if (responseEntity != null && null != responseEntity.getBody()) {
            return responseEntity.getBody().getResponse();
        }
        return null;
    }

    @Override
    public EchoConvertChartResultData convertChartDataset(AgileDataApiRequest request) {

        String url = AppContext.getApiUrlSetting().getEchoUrl() + "/api/ai/v1/agile/transPresent";

        Map<String, String> map = new HashMap<>(1);
        map.put("snapshotId", request.getDataId());
        map.put("transId", null == request.getTransId() ? "0" : request.getTransId());

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity = null;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(),
                    request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(map), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("convertChartDatasetV2接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}" +
                                "\n traceId:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity),
                        ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
                return null;
            }
        } catch (Exception e) {
            log.error("convertChartDatasetV2接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(request));
        }
        if (responseEntity != null && null != responseEntity.getBody()) {
            return JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse()), EchoConvertChartResultData.class);
        }
        return null;
    }

    @Override
    public AgileDataIntermediateDsl getAgileDataDsl(AgileDataApiRequest request) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + "/api/ai/v1/agile/report/show/" + request.getDataId();

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>> responseEntity = null;
        try {
            responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(),
                    request.getIamUserToken(), request.getTenantId()), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getAgileDataDsl接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}" +
                                "\n traceId:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity),
                        ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
                if (responseEntity.getBody() != null) {
                    return new AgileDataIntermediateDsl()
                            .setErrorMessage(responseEntity.getBody().getErrorMessage());
                }
            }
        } catch (Exception e) {
            log.error("getAgileDataDsl接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(request));
        }
        if (responseEntity != null && null != responseEntity.getBody()) {
            return responseEntity.getBody().getResponse();
        }
        return null;
    }

    @Override
    public EchoFilterData getFilterAgileData(AgileDataFilterQueryDTO request) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + "/api/ai/v1/agile/show/filter";

        AgileDataFilterQueryDTO agileDataFilterQueryDTO = BeanUtil.copyProperties(request, AgileDataFilterQueryDTO.class);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoFilterData>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoFilterData>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoFilterData>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(),
                    request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(agileDataFilterQueryDTO), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getFilterAgileData接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}" +
                                "\n traceId:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity),
                        ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
                EchoFilterData echoFilterData = new EchoFilterData();
                if (responseEntity.getBody() != null) {
                    echoFilterData.setErrorMessage(responseEntity.getBody().getErrorMessage());
                }
                return echoFilterData;
            }
            if (null != responseEntity.getBody()) {
                return JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse()), EchoFilterData.class);
            }
        } catch (Exception e) {
            log.error("getFilterAgileData接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(request));
        }
        return new EchoFilterData();
    }

    @Override
    public EchoAnalysisDataSummaryResultDTO getAttributionAnalysis(AgileDataAnalysisFluctuateQueryDTO request) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + "/api/ai/v1/analysis/show/attributionAnalysis";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAnalysisDataSummaryResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAnalysisDataSummaryResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoAnalysisDataSummaryResultDTO>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(),
                    request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(request), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getAttributionAnalysis接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}" +
                                "\n traceId:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity),
                        ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
                return new EchoAnalysisDataSummaryResultDTO();
            }
            if (null != responseEntity.getBody()) {
                return JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse()), EchoAnalysisDataSummaryResultDTO.class);
            }
        } catch (Exception e) {
            log.error("getAttributionAnalysis接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(request));
        }
        return new EchoAnalysisDataSummaryResultDTO();
    }

    @Override
    public EchoAnalysisDataDimensionResultDTO getAnalysisDataDimension(AgileDataAnalysisFluctuateQueryDTO request) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + "/api/ai/v1/analysis/show/dimensionAttribution";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAnalysisDataDimensionResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EchoAnalysisDataDimensionResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EchoAnalysisDataDimensionResultDTO>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(),
                    request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(request), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getAnalysisDataDimension接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}" +
                                "\n traceId:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity),
                        ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());

                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("getAnalysisDataDimension接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(request));
        }
        return null;
    }

    @Override
    public AgileDataEchoAutoDataReportResultDTO getAutoDataReportStatus(AgileDataAutoDataQueryDTO request) {
        String url = AppContext.getApiUrlSetting().getEchoUrl() + "/api/ai/agile/echo/autoData/getReport";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataEchoAutoDataReportResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataEchoAutoDataReportResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AgileDataEchoAutoDataReportResultDTO>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(),
                    request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(request), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getAutoDataReportStatus接口调用失败, url:{} " +
                                "\n request:{} " +
                                "\n responseEntity:{}" +
                                "\n traceId:{}",
                        url,
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity),
                        ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("getAutoDataReportStatus接口调用失败, url:{} \n request:{} ", url, JsonUtil.javaObjectToJsonString(request));
        }
        return null;
    }

}