package com.digiwin.mobile.mobileuibot.proxy.ai.model;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：ocr响应数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAiApiResponse
 * @Author: xujinc
 * @Date: 2023/6/19 14:23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DigiwinAiApiResponse<T> implements Serializable {
    private static final long serialVersionUID = 1875635261853793677L;

    /**
     * 返回码；
     * 0：正常
     * -1：普通异常
     * -2：业务异常，前端会Toast提示msg内容
     */
    private Integer code;
    private String msg;
    private T data;

    public static <T> DigiwinAiApiResponse<T> buildError() {
        return new DigiwinAiApiResponse<T>(-1, "error");
    }

    public <T> DigiwinAiApiResponse(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
