package com.digiwin.mobile.mobileuibot.proxy.ai.service;

import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumberResult;

import java.util.List;

/**
 * 大Ai接口服务类
 *
 * @author zhangjj
 * @date 2022/4/15 4:04 PM
 */
public interface DigiwinAiProxyService {

    /**
     * 获取推荐的报表code
     *
     * @param reportCodeList 所有报表code
     * @param userId
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<String> getRecommendedReport(List<String> reportCodeList, String userId, String iamUserToken, String tenantId);

    /**
     * 获取推荐的应用code
     *
     * @param menuCodeList
     * @param userId
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<String> getRecommendedMenu(List<String> menuCodeList, String userId, String iamUserToken, String tenantId);

    /**
     * 车牌识别
     *
     * @param locale
     * @param iamUserToken
     * @param userId
     * @param tenantId
     * @param image
     * @return
     */
    DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> getOcrCarNumber(String locale, String iamUserToken, String userId, String tenantId, String image);
}
