package com.digiwin.mobile.mobileuibot.proxy.ai.service.impl;

import com.digiwin.athena.ai.RequestHDL;
import com.digiwin.athena.ai.enums.CacData;
import com.digiwin.athena.ai.enums.OCR_CarData;
import com.digiwin.athena.ai.enums.RHResult;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.constant.TimeOutEnum;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.DigiwinAiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhangjj
 * @date 2022/4/15 4:07 PM
 */
@Slf4j
@Service
public class DigiwinAiProxyServiceImpl implements DigiwinAiProxyService {

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private HttpService httpService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public List<String> getRecommendedReport(List<String> reportCodeList, String userId, String iamUserToken, String tenantId) {
        List<String> recommendedReportCodeList = new ArrayList<>();
        if (reportCodeList == null || reportCodeList.isEmpty()) {
            return recommendedReportCodeList;
        }
        String url = sysEnvConfig.getAiUrl() + "/rs/recommended-report-list";

        boolean overdue = digiwinEspProxyService.checkProjectAmountOverdue(iamUserToken, tenantId, "zh_CN");
        boolean projectBehind = digiwinEspProxyService.checkProjectBackward(iamUserToken, tenantId, "zh_CN");
        Map<String, Integer> reportInformation = new HashMap<>();
        reportInformation.put("task_behind", projectBehind ? 1 : 0);
        reportInformation.put("task_overdue", overdue ? 1 : 0);

        Map<String, Object> body = new HashMap<>();
        List<Map<String, Object>> dataList =
                reportCodeList.stream().map(reportCode -> {
                    Map<String, Object> data = new HashMap<>();
                    data.put("tenant_id", tenantId);
                    data.put("user_id", userId);
                    data.put("report_id", reportCode);
                    data.put("report_code", reportCode);
                    data.put("report_information", reportInformation);
                    data.put("timestamp", System.currentTimeMillis());
                    return data;
                }).collect(Collectors.toList());
        body.put("data_list", dataList);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(body),
                        responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        List<String> resultList = new ArrayList<>();
        if (statusCode.is2xxSuccessful()) {
            List<Map<String, Object>> mapList = responseEntity.getBody().getResponse();
            if (mapList != null && !mapList.isEmpty()) {
                resultList = mapList.stream().map(map -> (String) map.get("report_code")).collect(Collectors.toList());
            }
        }
        return resultList;
    }

    @Override
    public List<String> getRecommendedMenu(List<String> menuCodeList, String userId, String iamUserToken, String tenantId) {
        {
            List<String> recommendedMenuCodeList = new ArrayList<>();
            if (menuCodeList == null || menuCodeList.isEmpty()) {
                return recommendedMenuCodeList;
            }
            String url = sysEnvConfig.getAiUrl() + "/rs/recommended-menu-list";
            Map<String, Object> body = new HashMap<>();
            List<Map<String, Object>> dataList =
                    menuCodeList.stream().map(menuCode -> {
                        Map<String, Object> data = new HashMap<>();
                        data.put("tenant_id", tenantId);
                        data.put("user_id", userId);
                        data.put("menu_id", menuCode);
                        data.put("menu_code", menuCode);
                        data.put("timestamp", System.currentTimeMillis());
                        return data;
                    }).collect(Collectors.toList());
            body.put("data_list", dataList);
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
                    };

            ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                    this.httpService.doPost(url,
                            new AthenaBasicHttpRequestHead(iamUserToken),
                            JsonUtil.javaObjectToJsonString(body),
                            responseType);
            HttpStatus statusCode = responseEntity.getStatusCode();

            List<String> resultList = new ArrayList<>();
            if (statusCode.is2xxSuccessful()) {
                List<Map<String, Object>> mapList = responseEntity.getBody().getResponse();
                if (mapList != null && !mapList.isEmpty()) {
                    resultList = mapList.stream().map(map -> (String) map.get("menu_code")).collect(Collectors.toList());
                }
            }
            return resultList;
        }
    }

    @Override
    public DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> getOcrCarNumber(String locale, String iamUserToken, String userId, String tenantId, String image) {
        String url = sysEnvConfig.getAiGetTopicQtyUrl() + "/api/gettopicqty";

        DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> digiwinAiApiResponse = new DigiwinAiApiResponse<>();
        try {
            AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
            athenaBasicHttpRequestHead.setLocale(locale);
            athenaBasicHttpRequestHead.setUserToken(iamUserToken);
            athenaBasicHttpRequestHead.setTenantId(tenantId);
            ResponseEntity<Map> responseEntity = this.httpService.doGet(url, athenaBasicHttpRequestHead, Collections.emptyMap(), Map.class);
            Object topicQtyObj = responseEntity.getBody().get("data");
            Integer topicQty = topicQtyObj != null ? (Integer) topicQtyObj : 10;

            OCR_CarData imgdata = new OCR_CarData();
            imgdata.setImage(image);
            imgdata.setMulti_detect("true");

            CacData cacData = new CacData();
            cacData.setUserID(userId);
            cacData.setUserToken(iamUserToken);

            RequestHDL requestHdl = new RequestHDL();
            RHResult resultJson = requestHdl.requestOCR_CAR(sysEnvConfig.getAikafkaUrl(), "AI", "1", iamUserToken, imgdata, cacData, TimeOutEnum.getSecondByEnvType().intValue(), topicQty);
            log.error("DigiwinAiProxyServiceImpl get Ai requestOCR_CAR info: {}", resultJson);

            digiwinAiApiResponse.setCode(resultJson.getCode());
            digiwinAiApiResponse.setMsg(resultJson.getMsg());

            if (resultJson.getData() != null) {
                digiwinAiApiResponse.setData(JsonUtil.jsonStringToObject(resultJson.getData(), DigiwinAiOcrCarNumberResult.class));
            }
        } catch (Throwable e) {
            log.error("DigiwinAiProxyServiceImpl getOcrCarNumber error: ", e);
            digiwinAiApiResponse = DigiwinAiApiResponse.buildError();
        }

        return digiwinAiApiResponse;
    }
}
