package com.digiwin.mobile.mobileuibot.proxy.aim.model;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：智驱AIM系统中消息主体数据模型，它包括了DigiwinAimMessageContent对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimMessage
 * @Author: Zaregoto
 * @Date: 2021/4/21 10:51
 */
public class DigiwinAimMessage implements Serializable {
    private static final long serialVersionUID = 441505348392097117L;

    private String gid;
    private String userId;
    private String tenantId;
    /**
     * 返回task或者activity、EOC。
     * task表示项目，activity表示任务，EOC表示提示消息
     *
     * @see com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTypeEnum
     */
    private String type;
    // 消息类型（eg. task_Consignment_Manufacturing）
    private String subType;
    // 消息类型所属子分类（eg. ATHENA_REMIND）
    private String subTypeCategory;

    /**
     * 智驱AIM消息分类
     *
     * @see com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum
     */
    private String category;
    private Integer importance;
    private String source;
    /**
     * 消息状态，，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;
    /**
     * 是否有详情
     */
    private Boolean hasReadDetail;
    private String title;
    private DigiwinAimMessageContent content;
    // YYYY-MM-DD HH:MM:SS
    private String sendDate;
    // YYYY-MM-DD HH:MM:SS
    private String createDate;

    private Object action;

    //统一消息中心字段
    private String channelType;

    public Object getAction() {
        return action;
    }

    public void setAction(Object action) {
        this.action = action;
    }

    public DigiwinAimMessage() {
    }

    public String getGid() {
        return gid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getSubTypeCategory() {
        return subTypeCategory;
    }

    public void setSubTypeCategory(String subTypeCategory) {
        this.subTypeCategory = subTypeCategory;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getImportance() {
        return importance;
    }

    public void setImportance(Integer importance) {
        this.importance = importance;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getTitle() {
        if (this.title == null || "null".equalsIgnoreCase(this.title)) {
            return "";
        }
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DigiwinAimMessageContent getContent() {
        return content;
    }

    public void setContent(DigiwinAimMessageContent content) {
        this.content = content;
    }

    public String getSendDate() {
        return sendDate;
    }

    public void setSendDate(String sendDate) {
        this.sendDate = sendDate;
    }

    public String getCreateDate() {
        return createDate;
    }

    public Boolean getHasReadDetail() {
        return hasReadDetail;
    }

    public void setHasReadDetail(Boolean hasReadDetail) {
        this.hasReadDetail = hasReadDetail;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public DigiwinAimMessageBoardCommenter getMessageBoardCommenter() {
        if (null == this.getContent() || null == this.getContent().getMessageBoard()) {
            return null;
        }
        List<DigiwinAimMessageBoard> messageBoardList = this.getContent().getMessageBoard();
        if (null != messageBoardList && !messageBoardList.isEmpty()) {
            DigiwinAimMessageBoard board = messageBoardList.get(0);
            return board.getCommenter();
        } else {
            return null;
        }
    }
}
