package com.digiwin.mobile.mobileuibot.proxy.aim.model;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：鼎捷AIM系统中内部消息留言人的数据模型</p>
 * 已重新equals方法，会根据userId判断是否是同一个人
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimMessageBoardCommenter
 * @Author: Zaregoto
 * @Date: 2021/4/28 21:15
 */
public class DigiwinAimMessageBoardCommenter implements Serializable {
    private static final long serialVersionUID = 8002990521777221474L;

    private List roles;
    private Long sid;
    private String tenantId;
    private String tenantName;
    private Long tenantSid;
    private String token;
    private String userId;
    private String userName;

    public DigiwinAimMessageBoardCommenter() {
    }

    public List getRoles() {
        return roles;
    }

    public void setRoles(List roles) {
        this.roles = roles;
    }

    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override public int hashCode() {
        // 参考：https://www.cnblogs.com/yuxiaole/p/9570850.html
        int result = 17;
        result = 31 * result + (userId == null ? 0 : userId.hashCode());
        return result;
    }

    @Override public boolean equals(Object obj) {
        if (obj instanceof DigiwinAimMessageBoardCommenter) {
            DigiwinAimMessageBoardCommenter otherCommenter = (DigiwinAimMessageBoardCommenter) obj;
            return this.getUserId().equals(otherCommenter.getUserId());
        } else {
            return super.equals(obj);
        }
    }
}
