package com.digiwin.mobile.mobileuibot.proxy.aim.model;

import com.digiwin.mobile.mobileuibot.notification.model.DigiwinAimMessageExtendContent;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷AIM系统中消息内容的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimMessageContent
 * @Author: Zaregoto
 * @Date: 2021/4/21 10:56
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAimMessageContent implements Serializable {
    private static final long serialVersionUID = 1968785330984768969L;

    /**
     * 资料ID。取决于上一级DigiwinAimMessageSummary中的type：若type=task，id表示项目id；若type=activity，id表示任务id
     */
    private String id;
    // S6_ztb,因获取到消息的title属性为JSON对象，故不能用字符串接收，先注释掉
//    private String title;
    /**
     * 开始时间
     * 格式：YYYY-MM-DD 00:00:00
     */
    private String startTime;

    /**
     * 结束时间
     * 格式：YYYY-MM-DD 00:00:00
     */
    private String endTime;
    private String name;
    /**
     * 消息内容
     * <p>
     * 平台返回的该字段会是各种数据类型，并没有固定数据类型。
     * 目前是因为消息type=EOC时，会提醒用户到云控制台完成重要设定。
     * 如：
     * xxx 你好：
     * <p>
     * 当前用户设定不完整，请至云控制台完成以下重要设定
     * <p>
     * 1、共2位用户未与员工关联
     * <p>
     * 2、共1位员工未设定所属部门
     * <p>
     * 友善提醒：未完成上述设定将导致相关用户使用雅典娜过程中发生不可预期的异常
     * <p>
     * 具体详情请前往云控制台查看
     * 所以临时先把原来的String类型，改为Object类型，并单独写get方法处理以返回String。
     * TODO 未来要由产品规划针对EOC及其他类型消息做设计后完整支持。
     */
    private Object msg;
    private Integer status;
    /**
     * 用于跳转详情，对应接口的sharingCode
     */
    private String shareCode;
    private List<DigiwinAimMessageBoard> messageBoard;
    private String activityId;
    private ActivityName activityName;
    /**
     * 失败（异常）笔数
     */
    private Integer failedNum;
    private String masterId;
    /**
     * 正在审核笔数
     */
    private Integer processingNum;
    /**
     * 成功笔数
     */
    private Integer succeededNum;
    private String userId;
    private String timestamp;
    private String userToken;
    private UserJson userJson;

    /**
     * type = eoc 新增字段
     */
    private List<Map<String, Object>> headers;
    private List<Map<String, Object>> data;

    /**
     * type = reminder 类型 新增字段
     */
    private String backlogId;
    private String performerId;
    private String performerName;
    private String personInCharge;
    private String personInChargeName;
    private String planEndTime;
    private String projectCode;
    private String projectName;
    private String taskCode;
    // type=task时为对象
    private Object taskName;
    private String workItemId;

    /**
     * 新增/合并任务消息优化 新增对象
     */
    private DigiwinAimMessageContentMessageFiled messageFiled;

    private DigiwinAimMessageExtendContent extendDisplayContent;

    /**
     * 原来是String，但是定位消息显示不出来问题时候发现有title为{},需要兼容下
     */
    private Object title;

    /**
     * 智能文档新增参数
     */
    private String linkUrl;

    private DigiwinAimMessageContentConfig config;

    public String getTitle() {
        if (ObjectUtils.isEmpty(this.title)) {
            return "";
        }
        if (this.title instanceof String && "null".equalsIgnoreCase((String) this.title)) {
            return "";
        }
        return title.toString();
    }


    public String getMsg() {
        if (msg instanceof String) {
            return ObjectUtils.nullSafeToString(msg);
        }
        if (msg instanceof List) {
            List msgList = (List) msg;
            return this.appendListValueAsString(msgList);
        }
        return ObjectUtils.nullSafeToString(msg);
    }

    public Object getEocMsg() {
        return msg;
    }

    public void setMsg(Object msg) {
        this.msg = msg;
    }

    private String appendListValueAsString(List list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        StringBuilder sbValue = new StringBuilder();
        list.forEach(o -> {
            sbValue.append(ObjectUtils.nullSafeToString(o));
            sbValue.append(" ");
        });
        return sbValue.toString().trim();
    }
}