package com.digiwin.mobile.mobileuibot.proxy.aim.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：鼎捷Athena中AIM 消息摘要（message summary）的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimMessageSummary
 * @Author: Zaregoto
 * @Date: 2021/4/21 10:29
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAimMessageSummary implements Serializable {
    private static final long serialVersionUID = -3852932347811861965L;

    private Integer unreadCount;
    private String type;
    /**
     * 消息类型（eg. task_Consignment_Manufacturing）
     */
    private String subType;
    /**
     * 消息类型所属子分类（eg. ATHENA_REMIND）
     */
    private String subTypeCategory;
    /**
     * 消息分类（eg. EMERGENCY）
     */
    private String category;
    private DigiwinAimMessage message;


}
