package com.digiwin.mobile.mobileuibot.proxy.aim.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：鼎捷Athena中AIM 消息摘要（message summary）的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimMessageSummary
 * @Author: Zaregoto
 * @Date: 2021/4/21 10:29
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAimNewMessageSummary implements Serializable {
    private static final long serialVersionUID = -3852932347811861965L;

    /**
     * 消息主体
     */
    private List<DigiwinAimMessage> content;
    /**
     * 分页想关参数
     */
    private DigiwinAimMessagePageable pageable;
    /**
     * 是否是最后一页
     */
    private Boolean last;
    /**
     * 总计多少页
     */
    private Integer totalPages;
    /**
     * 总计多少笔数据
     */
    private Integer totalElements;
    /**
     * 当前页多少笔数据
     */
    private Integer numberOfElements;
    /**
     * 是否是第一页
     */
    private Boolean first;
    /**
     * 当前分页大小
     */
    private Integer size;
    /**
     * 当前页码
     */
    private Integer number;
    /**
     * 数据是否为空
     */
    private Boolean empty;

}
