package com.digiwin.mobile.mobileuibot.proxy.aim.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 到期应用提醒
 *
 * @author xujinc
 * @date 20230925
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExpireApplicationNoticeInfo implements Serializable {
    private static final long serialVersionUID = -3671432897142274050L;

    // 消息id
    private String gid;

    // 消息类型 buffer_period：缓冲期 data_retention_period：资料保留期
    private String type;

    // 用户id
    private String userId;

    // 租户id
    private String tenantId;

    // 消息内容
    private ExpireApplicationNoticeContent content;

    private String createDate;

    private String modifyDate;

    private String endTime;

    // 应用code
    private String appCode;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public class ExpireApplicationNoticeContent {
        private String msg;
    }
}
