package com.digiwin.mobile.mobileuibot.proxy.aim.service;

import com.digiwin.mobile.mobileuibot.proxy.aim.model.*;

import java.util.List;

/**
 * <p>功能描述：鼎捷AIM系统代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimProxyService
 * @Author: Zaregoto
 * @Date: 2021/4/20 20:40
 */
public interface DigiwinAimProxyService {

    String API_PREFIX = "/api/aim/v1";
    String NEW_API_PREFIX = "/api/aim/v2";

    List<DigiwinAimMessageSummary> listImportantMessageSummary(String locale, String userToken);

    /**
     * 获取所有消息列表
     *
     * @param locale
     * @param userToken
     * @param pageNum
     * @param pageSize
     * @return
     */
    DigiwinAimNewMessageSummary listMessageSummary(String locale, String userToken,
                                                   Integer pageNum, Integer pageSize);

    /**
     * 统计未读消息数量
     *
     * @param locale
     * @param userToken
     * @param state     给固定值0表示查询未读消息
     * @return
     */
    Integer countMessageUnRead(String locale, String userToken, Integer state);

    List<DigiwinAimWorknewsMessageSummary> listWorknewsMessageSummary(String locale, String iamUserToken);

    List<DigiwinAimMessage> listImportantMessageByAimMessageCategoryId(String locale, String userToken,
                                                                       String aimMessageCategoryId);

    List<DigiwinAimMessage> listMessageSummaryByAimMessageCategoryId(String locale, String userToken,
                                                                     Integer pageNum, Integer pageSize, String aimMessageCategoryId);

    /**
     * 设置某个消息分类已读
     *
     * @param locale
     * @param userToken
     * @param subTypeCategory Athena已有的消息分类。参考AthenaPcNotificationCategoryEnum
     * @return
     */
    Long setMessageCategoryRead(String locale, String userToken, String subTypeCategory);

    /**
     * 批量设置消息已读
     *
     * @param locale
     * @param iamUserToken
     * @param gidList
     * @return
     */
    Long batchMessageRead(String locale, String iamUserToken, List<String> gidList);

    /**
     * 查询应用到期消息提醒
     *
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<ExpireApplicationNoticeInfo> getExpireApplicationNoticeInfo(String iamUserToken, String tenantId);

    /**
     * 给用户发送消息通知
     *
     * @param iamUserToken
     * @param messageData
     * @Link <a href="http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#658d2425a5a497000b26b62f">...</a>
     */
    void sendUserMessage(String iamUserToken, String messageData);

    /**
     * 一键已读工作提醒
     *
     * @param locale
     * @param userToken
     * @return
     */
    Integer readAll(String locale, String userToken);

    /**
     * 获取租户路由类型
     *
     * @param userToken 用户token
     * @return PRE：预区。PROD：正式区
     */
    String getTenantRouteType(String userToken);

    /**
     * 一键清除工作提醒
     *
     * @return Integer
     */
    Integer oneClickRemove();
}
