package com.digiwin.mobile.mobileuibot.proxy.aim.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.*;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAimProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/4/21 11:08
 */
@Service("digiwinAimProxyService")
public class DigiwinAimProxyServiceImpl implements DigiwinAimProxyService {

    private static final Logger logger = LoggerFactory.getLogger(DigiwinAimProxyServiceImpl.class);

    private final HttpService httpService;

    public DigiwinAimProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public List<DigiwinAimMessageSummary> listImportantMessageSummary(String locale,
                                                                      String userToken) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.API_PREFIX
                + "/message/summary?importance={importance}";

        Map<String, String> uriVariables = new HashMap<>(1);
        uriVariables.put("importance", "1");

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAimMessageSummary>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAimMessageSummary>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAimMessageSummary>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken), uriVariables, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public DigiwinAimNewMessageSummary listMessageSummary(String locale, String userToken,
                                                          Integer pageNum, Integer pageSize) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.NEW_API_PREFIX
                + "/message/summary";

        Map<String, Object> uriVariables = new HashMap<>(2);
        uriVariables.put("channelType", "app");
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("pageSize", pageSize);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAimNewMessageSummary();
    }

    @Override
    public Integer countMessageUnRead(String locale, String userToken, Integer state) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.NEW_API_PREFIX
                + "/message/summary";

        Map<String, Object> uriVariables = new HashMap<>(1);
        uriVariables.put("channelType", "app");
        uriVariables.put("state", state);
        uriVariables.put("pageNum", 0);
        uriVariables.put("pageSize", 1);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        DigiwinAimNewMessageSummary digiwinAimNewMessageSummary = statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAimNewMessageSummary();
        return digiwinAimNewMessageSummary.getTotalElements();
    }

    @Override
    public List<DigiwinAimWorknewsMessageSummary> listWorknewsMessageSummary(String locale, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.API_PREFIX
                + "/worknews/message/summary";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAimWorknewsMessageSummary>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAimWorknewsMessageSummary>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAimWorknewsMessageSummary>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        Collections.emptyMap(), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAimMessage> listImportantMessageByAimMessageCategoryId(String locale, String userToken,
                                                                              String aimMessageCategoryId) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.API_PREFIX
                + "/message" + "/" + aimMessageCategoryId + "/summary?importance={importance}";

        Map<String, String> uriVariables = new HashMap<>(1);
        uriVariables.put("importance", "1");

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAimMessage>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAimMessage>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAimMessage>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken), uriVariables, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAimMessage> listMessageSummaryByAimMessageCategoryId(String locale, String userToken,
                                                                            Integer pageNum, Integer pageSize, String aimMessageCategoryId) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.NEW_API_PREFIX
                + "/message/summary";

        Map<String, Object> uriVariables = new HashMap<>(2);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("subTypeCategory", aimMessageCategoryId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAimNewMessageSummary>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse().getContent() : Collections.emptyList();
    }

    @Override
    public Long setMessageCategoryRead(String locale, String userToken, String subTypeCategory) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.API_PREFIX
                + "/message/read";

        Map<String, String> bodyPayload = new HashMap<>(2);
        bodyPayload.put("importance", "1");
        bodyPayload.put("subTypeCategory", subTypeCategory);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Long>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Long>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Long>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken),
                        JsonUtil.javaObjectToJsonString(bodyPayload), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : -1L;
    }

    @Override
    public Long batchMessageRead(String locale, String iamUserToken, List<String> gidList) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.NEW_API_PREFIX
                + "/message/read";
        Map<String, Object> bodyPayload = new HashMap<>(1);
        bodyPayload.put("gidList", gidList);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Long>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Long>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Long>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(bodyPayload), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : -1L;
    }

    @Override
    public List<ExpireApplicationNoticeInfo> getExpireApplicationNoticeInfo(String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2/expire/list";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ExpireApplicationNoticeInfo>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ExpireApplicationNoticeInfo>>>() {
                };
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setUserToken(iamUserToken);
        athenaBasicHttpRequestHead.setTenantId(tenantId);
        ResponseEntity<DigiwinAthenaApiResponse<List<ExpireApplicationNoticeInfo>>> responseEntity =
                httpService.doGet(url, athenaBasicHttpRequestHead, new HashMap<>(1), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful()
                && Optional.ofNullable(responseEntity).map(HttpEntity::getBody)
                .map(DigiwinAthenaApiResponse::getStatus).orElse(-1) == HttpStatus.OK.value()
                ? responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public void sendUserMessage(String iamUserToken, String messageData) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.NEW_API_PREFIX
                + "/batch/user/message";
        try {
            this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                    messageData, Object.class);
        } catch (Exception e) {
            logger.error("Iam给用户发送消息通知异常:{}", e.getMessage(), e);
        }
    }

    @Override
    public Integer readAll(String locale, String userToken) {

        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.NEW_API_PREFIX + "/message/readAll?channelType=app";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Integer>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken),
                        new HashMap<>(1), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? Objects.requireNonNull(responseEntity.getBody()).getResponse() : 0;
    }

    @Override
    public String getTenantRouteType(String userToken) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + DigiwinAimProxyService.API_PREFIX
                + "/tenant/route/getType?app=mui";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<String>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<String>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<String>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken),
                        new HashMap<>(1), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody().getResponse() : null;
    }

    @Override
    public Integer oneClickRemove() {
        String url = AppContext.getApiUrlSetting().getAimUrl() + NEW_API_PREFIX
                + "/message/summary/remove?channelType=app";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(),
                        new HashMap<>(1), responseType);

        Integer removeNum = 0;
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            removeNum = responseEntity.getBody().getResponse().getInteger("removeNum");
        }
        return removeNum;
    }
}
