package com.digiwin.mobile.mobileuibot.proxy.ania.service;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

/**
 * @author yanfeng
 * @date 2024/4/2
 */
@Slf4j
@Service("digiwinAniaProxyServiceImpl")
public class DigiwinAniaProxyServiceImpl implements DigiwinAniaProxyService {

    private final HttpService httpService;

    public DigiwinAniaProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public void sendMessage(String iamUserToken, String data) {
        String url = AppContext.getApiUrlSetting().getAniaUrl() + "/gpt/message/sendMessage";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };
        try {
            httpService.doPost(url,
                    new AthenaBasicHttpRequestHead(iamUserToken), data, responseType);
        } catch (Exception e) {
            log.error("B娜给云信发送消息异常:{}", e.getMessage(), e);
        }
    }
}