package com.digiwin.mobile.mobileuibot.proxy.atdm.model;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：Athena的ATDM系统请求实体类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtdmRequest
 * @Author: Zaregoto
 * @Date: 2021/11/11 21:39
 */
@Data
public class DigiwinAtdmRequest implements Serializable {
    private static final long serialVersionUID = -5370780270104320432L;

    private String actionId;
    private Map<String, Object> businessUnit;
    private Map<String, Object> parameter;
    private Map<String, Object> executeContext;

    /**
     * 分页查询参数
     */
    private PcUiBotPageInfo pageInfo;
    /**
     * 排序
     * "sort_info" : [{
     * "sort_field" : "requisitions_no",
     * "sort_type" : "asc",
     * "sort_seq" : "1"
     * },{
     * "sort_field" : "requisitions_seq",
     * "sort_type" : "desc",
     * "sort_seq" : "2"
     * }]
     */
    private List<Map<String, Object>> sortInfo;
    /**
     * 通用过滤
     * "search_info": [
     * {
     * "search_field": "name",
     * "search_operator": "equal",
     * "search_value": "印表機"
     * },
     * {
     * "search_field": "status",
     * "search_operator": "equal",
     * "search_value": "生效"
     * }
     * ]
     */
    private List<Map<String, Object>> searchInfo;

    public DigiwinAtdmRequest() {
    }

    public static DigiwinAtdmRequest create(String actionId, Map<String, Object> parameter,
                                            Map<String, Object> executeContext, Map<String, Object> businessUnit) {
        DigiwinAtdmRequest request = new DigiwinAtdmRequest();
        request.setActionId(actionId);
        request.setBusinessUnit(businessUnit);
        request.setParameter(parameter);
        request.setExecuteContext(executeContext);

        return request;
    }

    public static DigiwinAtdmRequest create(String actionId, Map<String, Object> parameter,
                                            Map<String, Object> executeContext, Map<String, Object> businessUnit,
                                            PcUiBotPageInfo pageInfo, List<Map<String, Object>> sortInfo, List<Map<String, Object>> searchInfo) {
        DigiwinAtdmRequest request = create(actionId, parameter, executeContext, businessUnit);
        request.setPageInfo(pageInfo);
        request.setSortInfo(sortInfo);
        request.setSearchInfo(searchInfo);

        return request;
    }

    public static DigiwinAtdmRequest create(String actionId, Map<String, Object> parameter, ApiRequestSubmit apiRequestSubmit) {
        JSONObject executeCtx = apiRequestSubmit.getRawData().getJSONObject("action").getJSONObject("executeContext");
        return DigiwinAtdmRequest.create(actionId, parameter, executeCtx, executeCtx.getJSONObject("businessUnit"));
    }

    public static DigiwinAtdmRequest create(String actionId, Map<String, Object> parameter, UiBotModel pcUiBotModel) {
        UiBotExecuteContext executeCtx = pcUiBotModel.getExecuteContext();
        return DigiwinAtdmRequest.create(actionId, parameter, executeCtx, executeCtx.getJSONObject("businessUnit"));
    }
}
