package com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：PCC应用中，任务对象的模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PccProjectTaskInfo
 * @Author: Zaregoto
 * @Date: 2021/6/29 21:14
 */
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
@Data
public class PccProjectTaskInfo implements Serializable {
    private static final long serialVersionUID = 9002291529132843488L;

    private int actualDays;
    // YYYY-MM-DD
    private String actualFinishDate;
    // YYYY-MM-DD
    private String actualStartDate;
    private String arStageName;
    private String arStageNo;
    private UiBotAttachment attachment;
    private String attachmentRemark;
    private Double beforeTaskCompleteRate;
    private String beforeTaskNo;
    private String beforeTaskStatus;
    private String businessInfo;
    private String companyNo;
    private Double completeRate;
    private String completeRateMethod;
    private Integer completeMainUnitValue;
    private Integer completeRateGatter;
    private Integer completeReworkDays;
    private Integer completeReworkDrawingQty;
    private Integer completeReworkWorkHours;
    private Integer completeSecondUnitValue;
    private String contractNo;
    private String displayProjectNo;
    private String docConditionValue;
    private String docNo;
    private String docTypeNo;
    private String eocCompanyId;
    private String eocRegionId;
    private String eocSiteId;
    private Boolean isApprove;
    private Boolean isAttachment;
    private Boolean closedStus;
    private Boolean isEquipmentListUnfold;
    private Boolean isIssueTaskCard;
    private Boolean isMilepost;
    private Boolean isNeedDocNo;
    private Boolean isProjectNo;
    private Boolean isTaskNo;
    private Boolean isConfirmDate;
    private Boolean isDocDate;
    private Boolean disabled;
    private Boolean isChildrenshow;
    private Boolean isOperationsShow;
    private Boolean isOverdue;
    private String itemConditionValue;
    private String itemOperator;
    private String itemType;
    private String itemTypeName;
    private String itemTypeValue;
    private Integer level;
    private String liablePersonCode;
    private String liablePersonDepartmentCode;
    private String liablePersonDepartmentName;
    private String liablePersonName;
    private String liablePersonRoleName;
    private String liablePersonRoleNo;
    private String mainUnit;
    private Integer mainUnitActualValue;
    private String milepostDesc;
    private Double newCompleteRate;
    private String newTaskCategory;
    private String outsourcingConditionValue;
    private String outsourcingFieldCode;
    private String overdueDays;

    // YYYY-MM-DD
    private String planFinishDate;
    // YYYY-MM-DD
    private String planStartDate;
    private Double planWorkHours;
    private String productType;
    private String projectLeaderCode;
    private String projectLeaderName;
    // YYYY-MM-DD
    private String projectName;
    private String projectNo;
    private String projectStatus;
    private String remark;
    private String remarks;
    private Boolean requiredTask;
    private String salesName;
    private String salesNo;
    private String seq;
    private Integer sequence;
    private String subTypeConditionValue;
    private String subTypeFieldCode;
    private String taskCategory;
    private String taskClassificationName;
    private String taskClassificationNo;
    private List<Map<String, Object>> taskDependencyInfo;
    private List<Map<String, Object>> taskMemberInfo;
    private String taskName;
    private String taskNo;
    private String taskStatus;
    private String taskProperty;
    private String taskTag;
    private String taskTagDescription;
    private String taskTemplateName;
    private String taskTemplateNo;
    private Double totalWorkHours;
    private String typeConditionValue;
    private String typeFieldCode;
    private String upperLevelTaskNo;
    private Double workHours;
    private Double workloadQty;
    private String workloadUnit;


    private String difficultyLevelNo;
    private Integer reworkDrawingQty;
    private String processStatus;
    private Integer standardWorkHours;
    private String rootTaskNo;
    private Integer reworkWorkHours;
    private Integer planSecondUnitValue;
    private Integer standardDays;
    private Integer difficultyCoefficient;
    private String secondUnit;
    private String projectPlanFinishDate;
    private List<Object> taskReportInfo;
    private Integer planMainUnitValue;
    private Integer secondUnitActualValue;
    private Integer taskProportion;
    private Boolean updateFlag;
    private String difficultyLevelName;
    private String projectPlanStartDate;
    private String reportWorkDescription;

    /**
     * 返回当前任务的所有下一级任务
     *
     * @param allProjectTaskInfoList 所有任务列表
     * @return
     */
    public List<PccProjectTaskInfo> filterNextLevelProjectTaskInfo(
            List<PccProjectTaskInfo> allProjectTaskInfoList) {
        return
                allProjectTaskInfoList.stream()
                        // 排除自己
                        .filter(projectTaskInfo ->
                                !projectTaskInfo.getTaskNo().equalsIgnoreCase(this.getTaskNo()))
                        // 过滤出下一级子任务
                        .filter(projectTaskInfo ->
                                projectTaskInfo.getUpperLevelTaskNo().equalsIgnoreCase(this.getTaskNo()))
                        .collect(Collectors.toList());
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isOverdue() {
        return !this.getTaskStatus().equalsIgnoreCase(
                PccTaskStatusEnum.DONE.getStatus()) &&
                DateTimeUtil.isBeforeNowDate(this.planFinishDate);

//        if (this.isNotDone()) {
//            if (StringUtil.isNotEmpty(this.getPlanFinishDate())) {
//                return DateTimeUtil.isBeforeNowDateTime(this.getPlanFinishDate() + " 23:59:59");
//            } else {
//                return false;
//            }
//        } else {
//            if (this.isActualStartDateOverdue() && !this.isActualFinishDateOverdue()) {
//                return false;
//            } else {
//                return true;
//            }
//        }
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isDone() {
        return this.getTaskStatus().equalsIgnoreCase(
                PccTaskStatusEnum.DONE.getStatus());
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isNotDone() {
        return this.isTodo() || this.isDoing();
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isDoing() {
        return this.getTaskStatus().equalsIgnoreCase(
                PccTaskStatusEnum.DOING.getStatus());
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isTodo() {
        return this.getTaskStatus().equalsIgnoreCase(
                PccTaskStatusEnum.TO_DO.getStatus());
    }

    /**
     * 获取工期天数（计划开始与计划完成日期的相差天数）
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public long getWorkPeriodInDay() {
        long datePeriod = DateTimeUtil.getDatePeriod(this.getPlanStartDate(), this.getPlanFinishDate());
        return datePeriod + 1;
    }

    /**
     * 获取任务的逾期天数（今天与计划完成日期的相差天数）
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public long getOverduePeriodInDay() {
        return DateTimeUtil.getDatePeriod(this.getPlanFinishDate(), DateTimeUtil.getTodayUseDefaultPattern());
    }

    /**
     * 获取计划开始日期距离1970年1月1日的天数
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public long getPlanStartDateEpochDay() {
        return DateTimeUtil.parseLocalDateUseDefaultPattern(this.getPlanStartDate()).toEpochDay();
    }

    /**
     * 获取计划结束日期距离1970年1月1日的天数
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public long getPlanFinishDateEpochDay() {
        return DateTimeUtil.parseLocalDateUseDefaultPattern(this.getPlanFinishDate()).toEpochDay();
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isActualStartDateOverdue() {
        if (StringUtil.isEmpty(this.getActualStartDate()) || StringUtil.isEmpty(this.getPlanStartDate())) {
            return false;
        }
        LocalDateTime actual = DateTimeUtil.parseUseDefaultPattern(this.getActualStartDate() + " 23:59:59");
        LocalDateTime plan = DateTimeUtil.parseUseDefaultPattern(this.getPlanStartDate() + " 23:59:59");
        return actual.isAfter(plan);
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isActualFinishDateOverdue() {
        if (StringUtil.isEmpty(this.getActualFinishDate()) || StringUtil.isEmpty(this.getPlanFinishDate())) {
            return false;
        }
        LocalDateTime actual = DateTimeUtil.parseUseDefaultPattern(this.getActualFinishDate() + " 23:59:59");
        LocalDateTime plan = DateTimeUtil.parseUseDefaultPattern(this.getPlanFinishDate() + " 23:59:59");
        return actual.isAfter(plan);
    }


    public String getActualFinishDate() {
        return actualFinishDate;
    }

    public void setActualFinishDate(String actualFinishDate) {
        this.actualFinishDate = actualFinishDate;
    }

    public String getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(String actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public String getArStageName() {
        return arStageName;
    }

    public void setArStageName(String arStageName) {
        this.arStageName = arStageName;
    }

    public String getArStageNo() {
        return arStageNo;
    }

    public void setArStageNo(String arStageNo) {
        this.arStageNo = arStageNo;
    }

    public UiBotAttachment getAttachment() {
        return attachment;
    }

    public void setAttachment(UiBotAttachment attachment) {
        this.attachment = attachment;
    }

    public String getAttachmentRemark() {
        return attachmentRemark;
    }

    public void setAttachmentRemark(String attachmentRemark) {
        this.attachmentRemark = attachmentRemark;
    }

    public Double getBeforeTaskCompleteRate() {
        return beforeTaskCompleteRate;
    }

    public void setBeforeTaskCompleteRate(Double beforeTaskCompleteRate) {
        this.beforeTaskCompleteRate = beforeTaskCompleteRate;
    }

    public String getBeforeTaskNo() {
        return beforeTaskNo;
    }

    public void setBeforeTaskNo(String beforeTaskNo) {
        this.beforeTaskNo = beforeTaskNo;
    }

    public String getBusinessInfo() {
        return businessInfo;
    }

    public void setBusinessInfo(String businessInfo) {
        this.businessInfo = businessInfo;
    }

    public String getCompanyNo() {
        return companyNo;
    }

    public void setCompanyNo(String companyNo) {
        this.companyNo = companyNo;
    }

    public Double getCompleteRate() {
        return completeRate;
    }

    public void setCompleteRate(Double completeRate) {
        this.completeRate = completeRate;
    }

    public String getCompleteRateMethod() {
        return completeRateMethod;
    }

    public void setCompleteRateMethod(String completeRateMethod) {
        this.completeRateMethod = completeRateMethod;
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public String getDisplayProjectNo() {
        return displayProjectNo;
    }

    public void setDisplayProjectNo(String displayProjectNo) {
        this.displayProjectNo = displayProjectNo;
    }

    public String getDocConditionValue() {
        return docConditionValue;
    }

    public void setDocConditionValue(String docConditionValue) {
        this.docConditionValue = docConditionValue;
    }

    public String getDocNo() {
        return docNo;
    }

    public void setDocNo(String docNo) {
        this.docNo = docNo;
    }

    public String getDocTypeNo() {
        return docTypeNo;
    }

    public void setDocTypeNo(String docTypeNo) {
        this.docTypeNo = docTypeNo;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocRegionId() {
        return eocRegionId;
    }

    public void setEocRegionId(String eocRegionId) {
        this.eocRegionId = eocRegionId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getItemConditionValue() {
        return itemConditionValue;
    }

    public void setItemConditionValue(String itemConditionValue) {
        this.itemConditionValue = itemConditionValue;
    }

    public String getItemOperator() {
        return itemOperator;
    }

    public void setItemOperator(String itemOperator) {
        this.itemOperator = itemOperator;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemTypeName() {
        return itemTypeName;
    }

    public void setItemTypeName(String itemTypeName) {
        this.itemTypeName = itemTypeName;
    }

    public String getItemTypeValue() {
        return itemTypeValue;
    }

    public void setItemTypeValue(String itemTypeValue) {
        this.itemTypeValue = itemTypeValue;
    }

    public String getLiablePersonCode() {
        return liablePersonCode == null ? "" : liablePersonCode;
    }

    public void setLiablePersonCode(String liablePersonCode) {
        this.liablePersonCode = liablePersonCode;
    }

    public String getLiablePersonDepartmentCode() {
        return liablePersonDepartmentCode;
    }

    public void setLiablePersonDepartmentCode(String liablePersonDepartmentCode) {
        this.liablePersonDepartmentCode = liablePersonDepartmentCode;
    }

    public String getLiablePersonDepartmentName() {
        return liablePersonDepartmentName;
    }

    public void setLiablePersonDepartmentName(String liablePersonDepartmentName) {
        this.liablePersonDepartmentName = liablePersonDepartmentName;
    }

    public String getLiablePersonName() {
        return liablePersonName == null ? "" : liablePersonName;
    }

    public void setLiablePersonName(String liablePersonName) {
        this.liablePersonName = liablePersonName;
    }

    public String getMilepostDesc() {
        return milepostDesc;
    }

    public void setMilepostDesc(String milepostDesc) {
        this.milepostDesc = milepostDesc;
    }

    public Double getNewCompleteRate() {
        return newCompleteRate;
    }

    public void setNewCompleteRate(Double newCompleteRate) {
        this.newCompleteRate = newCompleteRate;
    }

    public String getNewTaskCategory() {
        return newTaskCategory;
    }

    public void setNewTaskCategory(String newTaskCategory) {
        this.newTaskCategory = newTaskCategory;
    }

    public String getOutsourcingConditionValue() {
        return outsourcingConditionValue;
    }

    public void setOutsourcingConditionValue(String outsourcingConditionValue) {
        this.outsourcingConditionValue = outsourcingConditionValue;
    }

    public String getOutsourcingFieldCode() {
        return outsourcingFieldCode;
    }

    public void setOutsourcingFieldCode(String outsourcingFieldCode) {
        this.outsourcingFieldCode = outsourcingFieldCode;
    }

    public String getPlanFinishDate() {
        return planFinishDate;
    }

    public void setPlanFinishDate(String planFinishDate) {
        this.planFinishDate = planFinishDate;
    }

    public String getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(String planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Double getPlanWorkHours() {
        return planWorkHours;
    }

    public void setPlanWorkHours(Double planWorkHours) {
        this.planWorkHours = planWorkHours;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProjectLeaderCode() {
        return projectLeaderCode;
    }

    public void setProjectLeaderCode(String projectLeaderCode) {
        this.projectLeaderCode = projectLeaderCode;
    }

    public String getProjectLeaderName() {
        return projectLeaderName;
    }

    public void setProjectLeaderName(String projectLeaderName) {
        this.projectLeaderName = projectLeaderName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectNo() {
        return projectNo;
    }

    public void setProjectNo(String projectNo) {
        this.projectNo = projectNo;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Boolean getRequiredTask() {
        return requiredTask;
    }

    public void setRequiredTask(Boolean requiredTask) {
        this.requiredTask = requiredTask;
    }

    public String getSalesName() {
        return salesName;
    }

    public void setSalesName(String salesName) {
        this.salesName = salesName;
    }

    public String getSalesNo() {
        return salesNo;
    }

    public void setSalesNo(String salesNo) {
        this.salesNo = salesNo;
    }

    public String getSeq() {
        return seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getSubTypeConditionValue() {
        return subTypeConditionValue;
    }

    public void setSubTypeConditionValue(String subTypeConditionValue) {
        this.subTypeConditionValue = subTypeConditionValue;
    }

    public String getSubTypeFieldCode() {
        return subTypeFieldCode;
    }

    public void setSubTypeFieldCode(String subTypeFieldCode) {
        this.subTypeFieldCode = subTypeFieldCode;
    }

    public String getTaskCategory() {
        return taskCategory;
    }

    public void setTaskCategory(String taskCategory) {
        this.taskCategory = taskCategory;
    }

    public String getTaskClassificationName() {
        return taskClassificationName;
    }

    public void setTaskClassificationName(String taskClassificationName) {
        this.taskClassificationName = taskClassificationName;
    }

    public String getTaskClassificationNo() {
        return taskClassificationNo;
    }

    public void setTaskClassificationNo(String taskClassificationNo) {
        this.taskClassificationNo = taskClassificationNo;
    }

    public List<Map<String, Object>> getTaskDependencyInfo() {
        return taskDependencyInfo;
    }

    public void setTaskDependencyInfo(List<Map<String, Object>> taskDependencyInfo) {
        this.taskDependencyInfo = taskDependencyInfo;
    }

    public List<Map<String, Object>> getTaskMemberInfo() {
        return taskMemberInfo;
    }

    public void setTaskMemberInfo(List<Map<String, Object>> taskMemberInfo) {
        this.taskMemberInfo = taskMemberInfo;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskNo() {
        return taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskTag() {
        return taskTag;
    }

    public void setTaskTag(String taskTag) {
        this.taskTag = taskTag;
    }

    public String getTaskTagDescription() {
        return taskTagDescription;
    }

    public void setTaskTagDescription(String taskTagDescription) {
        this.taskTagDescription = taskTagDescription;
    }

    public String getTaskTemplateName() {
        return taskTemplateName;
    }

    public void setTaskTemplateName(String taskTemplateName) {
        this.taskTemplateName = taskTemplateName;
    }

    public String getTaskTemplateNo() {
        return taskTemplateNo;
    }

    public void setTaskTemplateNo(String taskTemplateNo) {
        this.taskTemplateNo = taskTemplateNo;
    }

    public Double getTotalWorkHours() {
        return totalWorkHours;
    }

    public void setTotalWorkHours(Double totalWorkHours) {
        this.totalWorkHours = totalWorkHours;
    }

    public String getTypeConditionValue() {
        return typeConditionValue;
    }

    public void setTypeConditionValue(String typeConditionValue) {
        this.typeConditionValue = typeConditionValue;
    }

    public String getTypeFieldCode() {
        return typeFieldCode;
    }

    public void setTypeFieldCode(String typeFieldCode) {
        this.typeFieldCode = typeFieldCode;
    }

    public String getUpperLevelTaskNo() {
        return upperLevelTaskNo;
    }

    public void setUpperLevelTaskNo(String upperLevelTaskNo) {
        this.upperLevelTaskNo = upperLevelTaskNo;
    }

    public Double getWorkHours() {
        return workHours;
    }

    public void setWorkHours(Double workHours) {
        this.workHours = workHours;
    }

    public Double getWorkloadQty() {
        return workloadQty;
    }

    public void setWorkloadQty(Double workloadQty) {
        this.workloadQty = workloadQty;
    }

    public String getWorkloadUnit() {
        return workloadUnit;
    }

    public void setWorkloadUnit(String workloadUnit) {
        this.workloadUnit = workloadUnit;
    }

    public Boolean getIsApprove() {
        return isApprove;
    }

    public void setIsApprove(Boolean isApprove) {
        this.isApprove = isApprove;
    }

    public Boolean getIsAttachment() {
        return isAttachment;
    }

    public void setIsAttachment(Boolean isAttachment) {
        this.isAttachment = isAttachment;
    }

    public Boolean getIsConfirmDate() {
        return isConfirmDate;
    }

    public void setIsConfirmDate(Boolean isConfirmDate) {
        this.isConfirmDate = isConfirmDate;
    }

    public Boolean getIsDocDate() {
        return isDocDate;
    }

    public void setIsDocDate(Boolean isDocDate) {
        this.isDocDate = isDocDate;
    }

    public Boolean getIsEquipmentListUnfold() {
        return isEquipmentListUnfold;
    }

    public void setIsEquipmentListUnfold(Boolean isEquipmentListUnfold) {
        this.isEquipmentListUnfold = isEquipmentListUnfold;
    }

    public Boolean getIsIssueTaskCard() {
        return isIssueTaskCard;
    }

    public void setIsIssueTaskCard(Boolean isIssueTaskCard) {
        this.isIssueTaskCard = isIssueTaskCard;
    }

    public Boolean getIsMilepost() {
        return isMilepost;
    }

    public void setIsMilepost(Boolean isMilepost) {
        this.isMilepost = isMilepost;
    }

    public Boolean getIsNeedDocNo() {
        return isNeedDocNo;
    }

    public void setIsNeedDocNo(Boolean isNeedDocNo) {
        this.isNeedDocNo = isNeedDocNo;
    }

    public Boolean getIsProjectNo() {
        return isProjectNo;
    }

    public void setIsProjectNo(Boolean isProjectNo) {
        this.isProjectNo = isProjectNo;
    }

    public Boolean getIsTaskNo() {
        return isTaskNo;
    }

    public void setIsTaskNo(Boolean isTaskNo) {
        this.isTaskNo = isTaskNo;
    }

}
