package com.digiwin.mobile.mobileuibot.proxy.atdm.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.operation.OperationDownload;
import com.digiwin.mobile.mobileuibot.operation.OperationExport;
import com.digiwin.mobile.mobileuibot.operation.OperationExportFile;
import com.digiwin.mobile.mobileuibot.operation.OperationImportFile;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataReq;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataResult;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkWoData;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜项目任务数据服务调用类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtdmProxyService
 * @Author: Zaregoto
 * @Date: 2021/6/28 21:31
 */
public interface DigiwinAtdmProxyService {

    String DATA_API_PREFIX = "/api/atdm/v1/data";
    String ACTION_API_PREFIX = "/api/atdm/v1/action";
    String BASEDATAENTRY_PREFIX = "/baseDataEntry";

    PccApiDataWrapper<PccProjectInfo> dataQueryByActionProjectInfo(
            String locale, String iamUserToken, String bodyData, String tenantId);

    PccApiDataWrapper<PccProjectTaskInfo> dataQueryByActionProjectTaskInfo(
            String locale, String iamUserToken, String bodyData, String tenantId);

    /**
     * 获取项目本案新建时的项目编号
     *
     * @param iamUserToken
     * @param userId
     * @param locale
     * @return
     */
    String getProjectNo(String iamUserToken, String userId, String locale, String tenantId);

    /**
     * 查询标签信息
     * actionId: bm.bcsc.barcode.get
     *
     * @param locale
     * @param iamUserToken
     * @param bodyData
     * @return
     */
    List<ZhilinkBarcodeData> getBarcodeData(String locale, String iamUserToken, String bodyData, String tenantId);

    /**
     * 查询工单信息
     * actionId: zhilink.wo.info.get
     *
     * @param locale
     * @param iamUserToken
     * @param bodyData
     * @return
     */
    List<ZhilinkWoData> getWoInfoData(String locale, String iamUserToken, String bodyData, String tenantId);

    /**
     * 通用ATDM接口调用逻辑
     *
     * @param locale
     * @param iamUserToken
     * @param bodyData
     * @return
     */
    DigiwinAthenaApiResponse<Map<String, Object>> dataQueryByActionId(String locale,
                                                                      String iamUserToken, String bodyData, String tenantId);

    /**
     * Tbds的调用下一个物料数据
     *
     * @param locale
     * @param iamUserToken
     * @param bodyData
     * @param tenantId
     * @return
     */
    List<Map<String, Object>> tbdsDataQueryByActionId(String locale,
                                                      String iamUserToken, String bodyData, String tenantId);

    /**
     * 调用签核提交按钮
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    Boolean actionExecute(String locale,
                          String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * 调用人员上线按钮
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    Map<String, Object> peopleOnline(String locale,
                                     String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * 调用取消上线按钮
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    Boolean cancelOnline(String locale,
                         String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * 调用人员下线按钮
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    Map<String, Object> peopleOffline(String locale,
                                      String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * 调用进度提交按钮
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<JSONObject> projectScheduleSubmin(String locale,
                                                               String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * action提交按钮-带proxyToken
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param proxyToken
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<JSONObject> handleByActionId(String locale, String iamUserToken,
                                                          String tenantId, String proxyToken, Map<String, Object> params);

    /**
     * action提交按钮-带proxyToken
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param proxyToken
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<JSONObject> handleByAction(String locale, String iamUserToken,
                                                        String tenantId, String proxyToken, Map<String, Object> params);

    /**
     * 调用异常提交按钮
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    Map<String, Object> abnormalReportSubmin(String locale,
                                             String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * 获取标准任务卡的数据数量
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @param tenantId
     * @return
     */
    Integer getDataSize(String locale, String iamUserToken, Map<String, Object> params, String tenantId);

    /**
     * 提交接口（APC异常回报的回复按钮）
     *
     * @param locale
     * @param iamUserToken
     * @param bodyData
     * @param tenantId
     * @return
     */
    Boolean submitDataQueryByActionId(String locale,
                                      String iamUserToken, String bodyData, String tenantId);

    /**
     * 调用atdm，查询数据和元数据结果
     *
     * @param locale
     * @param iamUserToken
     * @param bodyPayload
     * @param tenantId
     * @return
     */
    QueryResultSet queryWithMetaData(String locale, String iamUserToken, String bodyPayload, String tenantId);

    QueryResultSet queryByActivityQueryDTO(String locale, String iamUserToken, String bodyPayload, String tenantId);

    /**
     * @param iamUserToken
     * @param paras
     * @param tmAction
     * @return
     */
    Object getAtDmDataQueryByAction(String iamUserToken, Object paras, Object tmAction);

    /** 查询数据-目前v2使用
     *
     * @param bodyData
     */
    DigiwinAtdmQueryPageDataResult queryPageDataByDataset(String locale, String iamUserToken, String tenantId, DigiwinAtdmQueryPageDataReq bodyData);

    /**
     * 下载模板接口
     *
     * @param iamUserToken
     * @param operationDownload
     * @param actionId
     * @return
     */
    ByteArrayResource downloadTemplate(String iamUserToken, String locale, OperationDownload operationDownload, String actionId);

    /**
     * 导出接口
     *
     * @param iamUserToken
     * @param operationExport
     * @return
     */
    Boolean operationExport(String iamUserToken, String locale, OperationExport operationExport);

    /**
     * 查询导出记录
     *
     * @param iamUserToken
     * @param queryMap
     * @return
     */
    List<OperationExportFile> queryExportRecords(String iamUserToken, String locale, Map<String, Integer> queryMap);

    /**
     * 导出文件下载接口
     *
     * @param iamUserToken
     * @param queryMap
     * @return
     */
    ByteArrayResource downloadExportFile(String iamUserToken, String locale, Map<String, String> queryMap);

    /**
     * 批量导入接口
     *
     * @param iamUserToken
     * @param files
     * @param querpMap
     * @return
     */
    ResponseEntity<Object> operationImport(String iamUserToken, String locale, List<MultipartFile> files, Map querpMap);


    List<OperationImportFile> getImportRecords(String iamUserToken, String locale);
}