package com.digiwin.mobile.mobileuibot.proxy.atdm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.operation.OperationDownload;
import com.digiwin.mobile.mobileuibot.operation.OperationExport;
import com.digiwin.mobile.mobileuibot.operation.OperationExportFile;
import com.digiwin.mobile.mobileuibot.operation.OperationImportFile;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataReq;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataResult;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkWoData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtdmProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/6/29 21:06
 */
@Service("digiwinAtdmProxyService")
public class DigiwinAtdmProxyServiceImpl implements DigiwinAtdmProxyService {

    private static final Logger logger = LoggerFactory.getLogger(DigiwinAtdmProxyServiceImpl.class);

    @Autowired
    private HttpService httpService;

    @Autowired
    private LocaleService localeService;

    @Override
    public PccApiDataWrapper<PccProjectInfo> dataQueryByActionProjectInfo(
            String locale, String iamUserToken, String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<PccApiDataWrapper<PccProjectInfo>>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<PccApiDataWrapper<PccProjectInfo>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<PccApiDataWrapper<PccProjectInfo>>>
                responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() :
                new PccApiDataWrapper<>();
    }

    @Override
    public PccApiDataWrapper<PccProjectTaskInfo> dataQueryByActionProjectTaskInfo(
            String locale, String iamUserToken, String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<PccApiDataWrapper<PccProjectTaskInfo>>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<PccApiDataWrapper<PccProjectTaskInfo>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<PccApiDataWrapper<PccProjectTaskInfo>>>
                responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() :
                new PccApiDataWrapper<>();
    }

    @Override
    public String getProjectNo(String iamUserToken, String userId, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/action";
        JSONObject bodyData = new JSONObject();
        JSONObject tmAction = new JSONObject();
        tmAction.put("sequence", 0);
        tmAction.put("type", "ESP");
        tmAction.put("actionId", "esp_project.code.info.get");
        bodyData.put("tmAction", tmAction);
        JSONObject paras = new JSONObject();
        JSONArray salesmanInfo = new JSONArray();
        JSONObject info = new JSONObject();
        info.put("salesman_no", userId);
        salesmanInfo.add(info);
        paras.put("salesman_info", salesmanInfo);
        bodyData.put("paras", paras);

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(bodyData), responseType);
        String projectNo = "";
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            JSONArray dataArr = responseEntity.getBody().getResponse().getJSONArray("data");
            if (dataArr != null && dataArr.size() > 0) {
                projectNo = dataArr.getJSONObject(0).getString("project_no");
            }
        }
        return projectNo;
    }

    @Override
    public List<ZhilinkBarcodeData> getBarcodeData(String locale, String iamUserToken,
                                                   String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, List<ZhilinkBarcodeData>>>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, List<ZhilinkBarcodeData>>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, List<ZhilinkBarcodeData>>>>
                responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (!statusCode.is2xxSuccessful()) {
            return null;
        }
        List<ZhilinkBarcodeData> barcodeDataList =
                responseEntity.getBody().getResponse().get("barcode_data");
        if (barcodeDataList != null) {
            return barcodeDataList;
        }
        return null;
    }

    @Override
    public List<ZhilinkWoData> getWoInfoData(String locale, String iamUserToken, String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, List<ZhilinkWoData>>>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, List<ZhilinkWoData>>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, List<ZhilinkWoData>>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (!statusCode.is2xxSuccessful()) {
            return null;
        }
        List<ZhilinkWoData> woInfoDataList = responseEntity.getBody().getResponse().get("wo_data");
        if (woInfoDataList != null) {
            return woInfoDataList;
        }
        return null;
    }

    @Override
    public DigiwinAthenaApiResponse<Map<String, Object>> dataQueryByActionId(String locale,
                                                                             String iamUserToken, String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public List<Map<String, Object>> tbdsDataQueryByActionId(String locale, String iamUserToken, String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.is2xxSuccessful() && responseEntity.getBody() != null
                && !CollectionUtils.isEmpty(responseEntity.getBody().getResponse())) {
            return (List<Map<String, Object>>) responseEntity.getBody().getResponse().get("op_data");
        }

        return Collections.emptyList();
    }

    @Override
    public Boolean actionExecute(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + ACTION_API_PREFIX
                + "/execute";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? (Boolean) responseEntity.getBody().getResponse().get("completed") : false;
    }

    @Override
    public Map<String, Object> peopleOnline(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Boolean cancelOnline(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        Map<String, Object> response = responseEntity.getBody().getResponse();
        if (response.get("error_msg") != null && StringUtils.hasLength((String) response.get("error_msg"))) {
            throw new ServiceException((String) response.get("error_msg"));
        }
        return true;
    }

    @Override
    public Map<String, Object> peopleOffline(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public DigiwinAthenaApiResponse<JSONObject> projectScheduleSubmin(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };
        //进度回报：进度回报按钮提交使用 header
        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        JSONObject response = responseEntity.getBody().getResponse();
        String errorMsg = response.getString("error_msg");
        if (StringUtils.hasLength(errorMsg)) {
            throw new ServiceException(errorMsg);
        } else {
            return responseEntity.getBody();
        }
    }

    @Override
    public DigiwinAthenaApiResponse<JSONObject> handleByActionId(String locale, String iamUserToken, String tenantId, String proxyToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId, proxyToken),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        JSONObject response = responseEntity.getBody().getResponse();
        String errorMsg = response.getString("error_msg");
        if (StringUtils.hasLength(errorMsg)) {
            throw new ServiceException(errorMsg);
        } else {
            return responseEntity.getBody();
        }
    }

    @Override
    public DigiwinAthenaApiResponse<JSONObject> handleByAction(String locale, String iamUserToken, String tenantId, String proxyToken,
                                                               Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/action";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId, proxyToken),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        JSONObject response = responseEntity.getBody().getResponse();
        String errorMsg = response.getString("error_msg");
        if (StringUtils.hasLength(errorMsg)) {
            throw new ServiceException(errorMsg);
        } else {
            return responseEntity.getBody();
        }
    }

    @Override
    public Map<String, Object> abnormalReportSubmin(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .map(r -> handleErrorMessage(r, locale))
                            .orElse("Api " + url + " call error!"));
        }
        Map<String, Object> response = responseEntity.getBody().getResponse();
        String errorMsg = (String) response.get("error_msg");
        if (StringUtils.hasLength(errorMsg)) {
            throw new ServiceException(errorMsg);
        } else {
            return response;
        }

    }

    @Override
    public Integer getDataSize(String locale, String iamUserToken, Map<String, Object> params, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/size/by/dataSource";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        //(Boolean) responseEntity.getBody().getResponse().get("completed")
        return statusCode.is2xxSuccessful() ? (Integer) responseEntity.getBody().getResponse().get("size") : 0;
    }

    @Override
    public Boolean submitDataQueryByActionId(String locale, String iamUserToken, String bodyData, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/actionId";

        ResponseEntity responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyData, Map.class);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful();
    }

    @Override
    public QueryResultSet queryWithMetaData(String locale, String iamUserToken, String bodyPayload, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/backlog/withmetadata";

//        Map<String, Object> body = new HashMap<>();
//        body.put("dataSourceSetDTO", dataSourceSet);
//        body.put("executeContext", executeContext);
//        body.put("parameter", parameter);
////        body.put("settings",pageDefine.getSettings());
//        if (pageInfo != null) {
//            body.put("pageInfo", pageInfo);
//        }
//        if (sortInfo != null && sortInfo.size() > 0) {
//            body.put("sortInfo", sortInfo);
//        }
//        if (searchInfo != null && searchInfo.size() > 0) {
//            body.put("searchInfo", searchInfo);
//        }

        ParameterizedTypeReference<DigiwinAthenaApiResponse<QueryResultSet>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<QueryResultSet>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<QueryResultSet>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyPayload, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .orElse("Api " + url + " call error!"));
        }
        QueryResultSet queryResultSet = responseEntity.getBody().getResponse();
        //合并多任务卡数据源
        Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
        for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
            // add for 50243:全局参数没有dataKey等信息，也不需要设置重新设置主数据源
            if (PcUiBotConstants.DataSourceName.UIBOT_GLOBAL_PARAMETER.equals(groupItem.getKey())) {
                continue;
            }
            List<QueryResult> resultList = groupItem.getValue();
            if (resultList.size() > 1) {
                QueryResult qr = resultList.get(0);
                for (int i = 1; i < resultList.size(); i++) {
                    // 修改多任务卡总数不对
                    Integer totalResults = qr.getTotalResults();
                    if (totalResults == null) {
                        qr.setTotalResults(resultList.get(i).getTotalResults());
                    } else {
                        Integer total = resultList.get(i).getTotalResults();
                        if (total != null) {
                            qr.setTotalResults(totalResults + total);
                        }
                    }
                    qr.getData().addAll(resultList.get(i).getData());
                    qr.getDataKeyIndex().putAll(resultList.get(i).getDataKeyIndex());
                    //有可能第一个 QueryResult 没有查到数据，所以需要根据条件更新 DataKeys 和 ApiMetadataCollection
                    if (CollectionUtils.isEmpty(qr.getDataKeys()) && !CollectionUtils.isEmpty(resultList.get(i).getDataKeys())) {
                        qr.setDataKeys(resultList.get(i).getDataKeys());
                    }
                    if (qr.getApiMetadataCollection() == null && resultList.get(i).getApiMetadataCollection() != null) {
                        qr.withMetaData(resultList.get(i).getApiMetadataCollection());
                    }
                    queryResultSet.getQueryResults().remove(resultList.get(i));
                }
                queryResultSet.setMainQueryResult(qr);
            }
        }
        return queryResultSet;
    }

    @Override
    public QueryResultSet queryByActivityQueryDTO(String locale, String iamUserToken, String bodyPayload, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/backlog";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<QueryResultSet>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<QueryResultSet>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<QueryResultSet>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        bodyPayload, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .orElse("Api " + url + " call error!"));
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Object getAtDmDataQueryByAction(String iamUserToken, Object paras, Object tmAction) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/by/action";
        JSONObject bodyData = new JSONObject();
        bodyData.put("tmAction", tmAction);
        bodyData.put("paras", paras);

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(bodyData), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return Objects.requireNonNull(responseEntity.getBody()).getResponse().get("data");
        }
        return null;
    }

    @Override
    public ByteArrayResource downloadTemplate(String iamUserToken, String locale, OperationDownload operationDownload, String actionId) {
        String url = AppContext.getApiUrlSetting().getImportexportUrl() + BASEDATAENTRY_PREFIX
                + "/downloadTemplate/" + actionId;
        ParameterizedTypeReference<byte[]> responseType =
                new ParameterizedTypeReference<byte[]>() {
                };
        ResponseEntity<byte[]> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                JsonUtil.javaObjectToJsonString(operationDownload), responseType);
        // 创建Resource对象并封装文件内容
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            ByteArrayResource resource = new ByteArrayResource(responseEntity.getBody());
            return resource;
        }
        return null;
    }

    @Override
    public Boolean operationExport(String iamUserToken, String locale, OperationExport operationExport) {
        String url = AppContext.getApiUrlSetting().getImportexportUrl() + BASEDATAENTRY_PREFIX
                + "/startDownload";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(operationExport), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return true;
        }
        return false;
    }

    @Override
    public List<OperationExportFile> queryExportRecords(String iamUserToken, String locale, Map<String, Integer> queryMap) {
        String url = AppContext.getApiUrlSetting().getImportexportUrl() + BASEDATAENTRY_PREFIX
                + "/queryExportRecords";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<OperationExportFile>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<OperationExportFile>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<OperationExportFile>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(queryMap), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity.getBody().getResponse();
        }
        return null;
    }

    @Override
    public ByteArrayResource downloadExportFile(String iamUserToken, String locale, Map<String, String> queryMap) {
        String url = AppContext.getApiUrlSetting().getImportexportUrl() + BASEDATAENTRY_PREFIX
                + "/downloadExportFile";
        ParameterizedTypeReference<byte[]> responseType =
                new ParameterizedTypeReference<byte[]>() {
                };
        ResponseEntity<byte[]> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                JsonUtil.javaObjectToJsonString(queryMap), responseType);
        // 创建Resource对象并封装文件内容
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            ByteArrayResource resource = new ByteArrayResource(responseEntity.getBody());
            return resource;
        }
        return null;
    }


    public ResponseEntity<Object> operationImport(String iamUserToken, String locale, List<MultipartFile> files, Map queryMap) {
        String url = AppContext.getApiUrlSetting().getImportexportUrl() + BASEDATAENTRY_PREFIX
                + "/uploadBatch";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };
        ResponseEntity<Object> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), files, queryMap, responseType);
        return responseEntity;
    }

    @Override
    public List<OperationImportFile> getImportRecords(String iamUserToken, String locale) {
        String url = AppContext.getApiUrlSetting().getImportexportUrl() + BASEDATAENTRY_PREFIX
                + "/getRecords";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<OperationImportFile>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<OperationImportFile>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<OperationImportFile>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(Collections.emptyMap()), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity.getBody().getResponse();
        }
        return null;
    }

    @Override
    public DigiwinAtdmQueryPageDataResult queryPageDataByDataset(String locale, String iamUserToken, String tenantId, DigiwinAtdmQueryPageDataReq bodyData) {
        String url = AppContext.getApiUrlSetting().getAtdmUrl() + DATA_API_PREFIX
                + "/query/page/by/dataset";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtdmQueryPageDataResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtdmQueryPageDataResult>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtdmQueryPageDataResult>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(bodyData), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(
                    Optional.ofNullable(responseEntity.getBody())
                            .map(DigiwinAthenaApiResponse::getErrorMessage)
                            .orElse("Api " + url + " call error!"));
        }
        return responseEntity.getBody().getResponse();
    }

    /**
     * S7 -- APP端错误提示存在多余内容，需要去除多余信息，只保留具体错误信息
     * 但atdm服务此迭代暂未处理，故需APP针对此提示特殊处理~~
     * https://atdm-test.apps.digiwincloud.com.cn/api/atdm/v1/data/query/by/actionId
     * <p>
     * 接口返回错误提示可能如下：
     * 调用api:%s异常,错误信息: %s
     * 调用api:%s异常，返回空
     * 调用api:%s异常，结果缺失std_data，返回结果:%s
     * 调用api:%s异常，结果缺失execution,返回结果：%s
     * 调用api:%s异常,返回结果:%s
     *
     * @param errorMessage
     * @param locale
     * @return
     */
    private String handleErrorMessage(String errorMessage, final String locale) {
        if (!StringUtils.hasLength(errorMessage)) {
            return errorMessage;
        }
        String error1 = localeService.getLanguageValue(locale, "错误信息");
        String error2 = localeService.getLanguageValue(locale, "返回结果");
        errorMessage = substringAfterLast(errorMessage, error1 + ":");
        errorMessage = substringAfterLast(errorMessage, error1 + "：");
        errorMessage = substringAfterLast(errorMessage, error2 + ":");
        errorMessage = substringAfterLast(errorMessage, error2 + "：");
        return errorMessage;
    }

    private static String substringAfterLast(final String str, final String separator) {
        if (!StringUtils.hasLength(str) || !StringUtils.hasLength(separator)) {
            return str;
        }
        final int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return str;
        }
        return str.substring(pos + separator.length());
    }
}