package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：BMP 和ATMC 数据集合</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcActivityData.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 13:26
 */
@Data
public class DigiwinAtmcActivityData {
    /**
     * 任务数据:包含BMP执行参数，ATMC 执行信息
     */
    private List<DigiwinAtmcTaskWithBacklogData> tasks;

    /**
     * 项目数据
     */
    private DigiwinAtmcProjectData project;

    /**
     * 88:预期任务；89：异动数据异常排除
     */
    private Integer type;

    /**
     * 异动数据
     */
    private List<Map> abnormalData;

    /**
     * 主卡关联的异动数据卡
     */
    private List<DigiwinAtmcBpmActivityWorkitem> abnormalCards;

    /**
     * 存放退回重签意见
     */
    private DigiwinAtmcBpmActivityWorkitem reapprovalInfo;

    /**
     * 数据来源：PTM表示来源于PTM，其他表示ATMC
     */
    private String dataFrom;
    /**
     * 摘要里是否需要显示历史资讯
     */
    private Boolean needHistoryInfo;
    /**
     * 数据一致性异常排除任务卡id
     */
    private Long abnormalWorkitemId;
    /**
     * 提交唯一键
     */
    private Integer submitId;
    /**
     * 是否是行事历任务
     */
    private Boolean calendar;
    /**
     * 是否存在签核
     */
    private Boolean hasApprove;
    /**
     * 数据主键（暂时用于数据清除的时候指定数据主键）
     */
    private String dataVariableKey;
}
