package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷Athena任务卡数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinApiAtmcBacklog
 * @Author: Zaregoto
 * @Date: 2021/4/21 1:11
 */
@Data
public class DigiwinAtmcBacklog implements Serializable {
    private static final long serialVersionUID = 8151071589965514279L;

    public static final Map<String, String> TASK_FLOW_MAP = new LinkedHashMap();
    public static final Map<String, String> TASK_READ_STATUS_MAP = new LinkedHashMap();
    public static final Map<String, String> TASK_STATUS_MAP = new LinkedHashMap();

    static {
//        TASK_FLOW_MAP.put("addTask", "加签");
        TASK_FLOW_MAP.put("reassign", "转派");
        TASK_FLOW_MAP.put("handover", "交接");
        TASK_FLOW_MAP.put("agent", "代理");
        TASK_FLOW_MAP.put("pinning", "他人分享");
        TASK_FLOW_MAP.put("other", "其他");
        TASK_READ_STATUS_MAP.put("read", "已读");
        TASK_READ_STATUS_MAP.put("unread", "未读");
        TASK_STATUS_MAP.put("overdueException", "异常/逾期");
        TASK_STATUS_MAP.put("emergency", "紧急");
        TASK_STATUS_MAP.put("dataChangeRead", "已变更");
//        TASK_STATUS_MAP.put("agent", "代理");
        TASK_STATUS_MAP.put("importance", "特别关注");
        TASK_STATUS_MAP.put("hasAppPermission", "未授权");
        TASK_STATUS_MAP.put("reexecute", "退回或退回重签");
        TASK_STATUS_MAP.put("addTask", "加签");
//        TASK_STATUS_MAP.put("pinning", "他人分享");
        TASK_STATUS_MAP.put("other", "其他");
    }

    //任务类型
    public static final String TASK_TYPE = "type";

    //任务来源节点
    public static final String TASK_OTHERTASKINFO = "otherTaskInfo";
    //任务来源节点-转派
    public static final String TASK_OTHERTASKINFO_REASSIGN = "reassign";
    //任务来源节点-交接
    public static final String TASK_OTHERTASKINFO_HANDOVER = "handover";
    //任务来源节点-代理
    public static final String TASK_OTHERTASKINFO_AGENT = "agent";
    //任务来源节点-他人分享
    public static final String TASK_OTHERTASKINFO_PINNING = "pinning";
    //任务来源节点-其他
    public static final String TASK_OTHERTASKINFO_OTHER = "other";

    //阅读状态
    public static final String TASK_READ_STATUS = "readStatus";
    //阅读状态-已读
    public static final String TASK_READ_STATUS_READ = "read";
    //阅读状态-未读
    public static final String TASK_READ_STATUS_UNREAD = "unread";

    //完成时间
    public static final String TASK_DATE_RANGE = "dateRange";

    //任务状态
    public static final String TASK_STATUS = "status";
    //任务状态-异常/逾期
    public static final String TASK_STATUS_OVERDUEEXCEPTION = "overdueException";
    //任务状态-紧急
    public static final String TASK_STATUS_EMERGENCY = "emergency";
    //任务状态-已变更
    public static final String TASK_STATUS_DATACHANGEREAD = "dataChangeRead";
    //任务状态-特别关注
    public static final String TASK_STATUS_IMPORTANCE = "importance";
    //任务状态-未授权
    public static final String TASK_STATUS_HASAPPPERMISSION = "hasAppPermission";
    //任务流程节点-退回或退回重签
    public static final String TASK_STATUS_REEXECUTE = "reexecute";
    //任务流程节点-加签
    public static final String TASK_STATUS_ADDTASK = "addTask";
    //任务状态-其他
    public static final String TASK_STATUS_OTHER = "other";

    private Boolean actionDefined;
    /**
     * 任务卡归属应用编码。如：PCC
     */
    private String appCode;

    /**
     * 任务卡归属应用名称。如：项目进度管理
     */
    private String appName;

    /**
     * 签核状态
     */
    private String approvalState;
    private Long backlogId;
    private String content;
    private Boolean emergency;
    // YYYY-MM-DD HH:MM:SS(24小时制)
    private String endTime;
    private String eocCode;
    private String eocName;
    private Integer eocType;
    private Boolean exception;
    private Boolean hasDataChanged;
    private Boolean importance;
    private Boolean importanceReadOnly;
    private Boolean isOwner;
    // YYYY-MM-DD HH:MM:SS(24小时制)
    private String modifyDate;
    private String name;
    /**
     * 代理人token
     */
    private String proxyToken;
    private String sourceTenantName;
    // 是否逾期
    private Boolean overdue;
    private Long overdueDays;
    private Long overdueHours;
    private Long overdueMinutes;
    private String ownerUserId;
    private String ownerUserName;
    // YYYY-MM-DD 00:00:00
    private String projectEndTime;
    private Boolean projectImportance;
    private String projectName;
    // YYYY-MM-DD 00:00:00
    private String projectStartTime;
    private String projectTargetName;
    private Long readCount;
    // YYYY-MM-DD HH:MM:SS(24小时制)
    private String startTime;
    private String subName;
    private String tenantId;
    private String tmActivityId;
    private String tmActivityName;

    //是否转派
    private Boolean reassign = false;
    private Boolean reAssignAble = false;

    //是否退回或退回重签
    private Boolean reexecute = false;

    //是否加签
    private Boolean addTask = false;

    // 撤回 (pc返回的值有问题，目前不能使用此字段判断撤回)
    private Boolean recall = false;

    private String tmCategory;
    private String tmPattern;
    private String tmTaskId;
    private Integer type;
    private String uri;
    private String summary;

    // 是否授权
    private Boolean hasAppPermission = true;

    // 运营单元-供应商未就绪，展示原因
    private String crossTenantError;

    // 运营单元-辅助单元-租户id
    private String auxiliaryTenantId;

    // 运营单元-辅助单元-租户名称
    private String auxiliaryTenantName;

    // 是否分享至他人 (由谁分享可以从ownerUserName获取)
    private Boolean pinning = false;

    // 引擎中是否有待处理
    private Boolean engineHasWaittingData = true;

    // 已变更
    private Boolean dataChangeRead;

    // 变更中
    private Boolean changed;

    // 是否合并任务卡
    private Boolean merge;

    private String planEndTimeMin;

    private String planEndTimeMax;

    /**
     * 是否交接，  approvalStateCode = 'handover' 或 item.handover 为 true
     */
    private String approvalStateCode;

    /**
     * 是否交接，  approvalStateCode = 'handover' 或 item.handover 为 true
     */
    private Boolean handover = false;

    /**
     * 自定义标签
     */
    private List<DigiwinAtmcLabel> labels;

    /**
     * 任务类型排序信息
     */
    private DigiwinAtmcOrder order;

    /**
     * 条目已经分组好的信息
     */
    private DigiwinAtmcGroup group;

    /**
     * 配置信息
     */
    private List<DigiwinAtmcCardConfigItem> cardConfig;

    private Map<String, Object> businessMessage;

    /**
     * 行事历发起任务专有
     */
    private DigiwinAtmcExtendData extendData;
    /**
     * 行事历团队名称
     */
    private String calenderTeamName;
    /**
     * 过滤用
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Boolean backlogtypeSupported;

    public DigiwinAtmcBacklog() {
    }

    public DigiwinAtmcBacklog(Long backlogId, String tmTaskId, String tmActivityId, String tmPattern, String tmCategory,
                              String tenantId) {
        this.backlogId = backlogId;
        this.tmTaskId = tmTaskId;
        this.tmActivityId = tmActivityId;
        this.tmPattern = tmPattern;
        this.tmCategory = tmCategory;
        this.tenantId = tenantId;
    }

    /**
     * 是否与其他任务卡拥有相同的项目id（taskid）与任务id（activityid）
     *
     * @param tmTaskId
     * @param tmActivityId
     * @return
     */
    public boolean isEqualWithBacklogInTaskIdAndActivityId(String tmTaskId, String tmActivityId) {
        return tmTaskId.equals(this.getTmTaskId()) && tmActivityId.equals(this.getTmActivityId());
    }

    /**
     * 是否为手动任务类型
     *
     * @return
     */
    public boolean isTypeOfManualTask() {
        return "uibotManualTask".equals(this.getTmActivityId());
    }

    public Boolean getActionDefined() {
        return actionDefined;
    }

    public void setActionDefined(Boolean actionDefined) {
        this.actionDefined = actionDefined;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getApprovalState() {
        return approvalState;
    }

    public void setApprovalState(String approvalState) {
        this.approvalState = approvalState;
    }

    public Long getBacklogId() {
        return backlogId;
    }

    public void setBacklogId(Long backlogId) {
        this.backlogId = backlogId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Boolean getEmergency() {
        return emergency;
    }

    public void setEmergency(Boolean emergency) {
        this.emergency = emergency;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getEocCode() {
        return eocCode;
    }

    public void setEocCode(String eocCode) {
        this.eocCode = eocCode;
    }

    public String getEocName() {
        return eocName;
    }

    public void setEocName(String eocName) {
        this.eocName = eocName;
    }

    public Integer getEocType() {
        return eocType;
    }

    public void setEocType(Integer eocType) {
        this.eocType = eocType;
    }

    public Boolean getException() {
        return exception;
    }

    public void setException(Boolean exception) {
        this.exception = exception;
    }

    public Boolean getHasDataChanged() {
        return hasDataChanged;
    }

    public void setHasDataChanged(Boolean hasDataChanged) {
        this.hasDataChanged = hasDataChanged;
    }

    public Boolean getImportance() {
        return importance;
    }

    public void setImportance(Boolean importance) {
        this.importance = importance;
    }

    public Boolean getImportanceReadOnly() {
        return importanceReadOnly;
    }

    public void setImportanceReadOnly(Boolean importanceReadOnly) {
        this.importanceReadOnly = importanceReadOnly;
    }

    public Boolean getIsOwner() {
        return isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public String getModifyDate() {
        return modifyDate;
    }

    public void setModifyDate(String modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getOverdue() {
        return overdue;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    public Long getOverdueDays() {
        return overdueDays;
    }

    public void setOverdueDays(Long overdueDays) {
        this.overdueDays = overdueDays;
    }

    public Long getOverdueHours() {
        return overdueHours;
    }

    public void setOverdueHours(Long overdueHours) {
        this.overdueHours = overdueHours;
    }

    public Long getOverdueMinutes() {
        return overdueMinutes;
    }

    public void setOverdueMinutes(Long overdueMinutes) {
        this.overdueMinutes = overdueMinutes;
    }

    public String getOwnerUserId() {
        return ownerUserId;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public String getOwnerUserName() {
        return ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }

    public String getProjectEndTime() {
        return projectEndTime;
    }

    public void setProjectEndTime(String projectEndTime) {
        this.projectEndTime = projectEndTime;
    }

    public Boolean getProjectImportance() {
        return projectImportance;
    }

    public void setProjectImportance(Boolean projectImportance) {
        this.projectImportance = projectImportance;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectStartTime() {
        return projectStartTime;
    }

    public void setProjectStartTime(String projectStartTime) {
        this.projectStartTime = projectStartTime;
    }

    public String getProjectTargetName() {
        return projectTargetName;
    }

    public void setProjectTargetName(String projectTargetName) {
        this.projectTargetName = projectTargetName;
    }

    public Boolean getReAssignAble() {
        return reAssignAble;
    }

    public void setReAssignAble(Boolean reAssignAble) {
        this.reAssignAble = reAssignAble;
    }

    public Long getReadCount() {
        return readCount;
    }

    public void setReadCount(Long readCount) {
        this.readCount = readCount;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getSubName() {
        if (this.subName == null) {
            return "";
        }
        return subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTmActivityId() {
        return tmActivityId;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public String getTmCategory() {
        return tmCategory;
    }

    public void setTmCategory(String tmCategory) {
        this.tmCategory = tmCategory;
    }

    public String getTmPattern() {
        return tmPattern;
    }

    public void setTmPattern(String tmPattern) {
        this.tmPattern = tmPattern;
    }

    public String getTmTaskId() {
        return tmTaskId;
    }

    public void setTmTaskId(String tmTaskId) {
        this.tmTaskId = tmTaskId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Boolean getBacklogtypeSupported() {
        this.backlogtypeSupported = false;
        if (null != this.type) {
            if (this.type.equals(DigiwinAtmcBacklogTypeEnum.UNEXPECTED.getValue())
                    || this.type.equals(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue())
                    || this.type.equals(DigiwinAtmcBacklogTypeEnum.CALENDAR.getValue())
                    || this.type.equals(DigiwinAtmcBacklogTypeEnum.TEAM_CALENDAR.getValue())
                    || this.type.equals(DigiwinAtmcBacklogTypeEnum.ANSWER_MAIN_ZERO.getValue())
                    || this.type.equals(DigiwinAtmcBacklogTypeEnum.ANSWER_ACCEPTANCE_ZERO.getValue())
                    || this.type.equals(DigiwinAtmcBacklogTypeEnum.REPLY_TASK.getValue())
            ) {
                backlogtypeSupported = true;
            }
        }

        return backlogtypeSupported;
    }

    public void setBacklogtypeSupported(Boolean backlogtypeSupported) {
        this.backlogtypeSupported = backlogtypeSupported;
    }

    public Boolean getOwner() {
        return isOwner;
    }

    public void setOwner(Boolean owner) {
        isOwner = owner;
    }

    public DigiwinAtmcExtendData getExtendData() {
        return extendData;
    }

    public void setExtendData(DigiwinAtmcExtendData extendData) {
        this.extendData = extendData;
    }

    public String getCalenderTeamName() {
        return calenderTeamName;
    }

    public void setCalenderTeamName(String calenderTeamName) {
        this.calenderTeamName = calenderTeamName;
    }


}
