package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @description: 活动--backlog 数据
 * @author: wangminga
 * @create: 2020-09-03 11:02
 **/

/**
 * <p>功能描述：鼎捷雅典娜任务中心任务数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcBacklogData
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class DigiwinAtmcBacklogData implements Serializable {

    private static final long serialVersionUID = -8736907558113365704L;
    /**
     * 代办ID
     */
    private Long backlogId;

    /**
     * 待办名称
     */
    private String backlogName;

    /**
     * 执行者ID
     */
    private String performerId;

    /**
     * 人员状态true在职，false离职
     */
    private Boolean performerState;

    /**
     * 执行者名称
     */
    private String performerName;

    /**
     * 前置任务的所有者id
     */
    private String prePerformerId;

    /**
     * 前置任务所有者名称
     */
    private String prePerformerName;

    //如果提交的是代理人或者辅助者执行者，则记录
    private String preAgentPerformerId;
    private String preAgentPerformerName;
    /**
     * 如果是1，是代理人执行，是2，辅助执行者执行
     */
    private Integer prePerformerType;

    /**
     * 已读次数
     */
    private Integer readCount;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 计划结束时间
     */
    private String planEndTime;

    /**
     * 没有endTime  就是未完成
     */
    private String endTime;

    /**
     * 倒计时
     */
    private String remainTime;

    /**
     * 逾期
     * 倒计时与逾期最多有一个，或者都没有
     */
    private String overdueDate;

    /**
     * 关卡处理的人
     */
    private List<Map<String, Object>> workitemList;

    /**
     * 是否已经处理过标记
     */
    private String finishedActionId;

    /**
     * 是否已经关闭
     */
    private boolean closed;

    private String bpmSignReason;

    private Long ptmBacklogId;
    private Long ptmWorkItemId;
    /**
     * 任务是否合并
     */
    private Boolean merge;
    /**
     * 最小预计完成时间 yyyy-MM-dd HH:mm:ss
     */
    private String planEndTimeMin;
    /**
     * 最大预计完成时间 yyyy-MM-dd HH:mm:ss
     */
    private String planEndTimeMax;

    /**
     * 0.正常产生;1.转派；2.退回重签；3.退回重办；4.加签；9.撤回重办
     */
    private Integer createType;

    /**
     * 提交唯一键
     */
    private Integer submitId;
    /**
     * 待办的执行人
     * 为了兼容辅助执行人，待办的执行人和workItem的执行人不同的情况
     */
    private String backlogPerformId;
}
