package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷Athena任务详情数据模型。注：这里字段的task是指项目信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcBacklogDetail
 * @Author: Zaregoto
 * @Date: 2021/5/17 15:29
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAtmcBacklogDetail implements Serializable {
    private static final long serialVersionUID = 405523872203359264L;

    private Boolean actionDefined;
    private String agentPerformerId;
    /**
     * 任务卡所属应用code。示例：PCC、PWD、APC
     */
    private String appCode;
    /**
     * 任务卡所属应用名称。示例：项目进度管理、装配进度管理
     */
    private String appName;
    /**
     * 签核状态
     */
    private String approvalState;
    // YYYY-MM-DD HH:MM:SS
    private String backLogEndTime;
    // YYYY-MM-DD HH:MM:SS
    private String backLogStartTime;
    private String backlogId;
    private String bpmActivityId;
    private String bpmSignReason;
    private Integer emergency;
    // YYYY-MM-DD HH:MM:SS
    private String endTime;
    private Boolean exception;
    private Boolean finished;
    /**
     * 所属应用是否有授权
     */
    private Boolean hasAppPermission;
    // 当前任务卡ID
    private Long id;
    private Integer importance;
    private Boolean isOwner;
    private Boolean merge;
    private String name;
    private Boolean overdue;
    private Long overdueMinutes;
    private Long overdueWorkitemId;
    private String overdueDate;
    private String performerId;
    private Integer performerType;
    private Long projectCardId;
    private String proxyToken;
    private Long readCount;
    /**
     * 转派信息，有三个key。最后一个key在2023年9月冲刺后，不应该再使用了。数据示例如下：
     * "reAssignAble": true,
     * "reassignSize": 1,
     * "reassignUsers": [{类型为DigiwinAtmcReassignUsers}]
     */
    private Map<String, Object> reassign;
    private String remainTime;
    private Boolean showTaskNameInTab;
    private Long submitId;
    private List<Step> steps;
    // 项目过期日期YYYY-MM-DD 00:00:00
    private String taskDueDate;
    // 项目过期日期展示名称
    private String taskDueDateName;
    // 项目结束日期YYYY-MM-DD 00:00:00
    private String taskEndTime;
    // 项目名称
    private String taskName;
    // 项目来源ID
    private List<String> taskSourceIds;
    // 项目来源名称
    private String taskSourceName;
    // 项目开始日期YYYY-MM-DD 00:00:00
    private String taskStartTime;
    private String tenantId;
    private String tmActivityId;
    private String tmCategory;
    private String tmPattern;
    private String tmTaskId;
    private Integer type;

    // 时间段
    private String planEndTimeMin;

    // 时间段
    private String planEndTimeMax;

    /**
     * 营运单元
     */
    private Map<String, Object> businessUnit;

    // 是否分享至他人
    private Boolean pinning;

    public static class Step implements Serializable {
        private static final long serialVersionUID = 4647641721066494894L;

        private Integer stepId;
        private String bpmActivityId;
        private String bpmActivityName;
        // YYYY-MM-DD HH:MM:SS
        private String startTime;
        // YYYY-MM-DD HH:MM:SS
        private String endTime;
        private Boolean current;

        public Step() {
        }

        public Step(Integer stepId, String bpmActivityId, String bpmActivityName, String startTime,
                    String endTime, Boolean current) {
            this.stepId = stepId;
            this.bpmActivityId = bpmActivityId;
            this.bpmActivityName = bpmActivityName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.current = current;
        }
    }

    /**
     * 是否与其他任务卡拥有相同的项目id（taskid）与任务id（activityid）
     *
     * @param tmTaskId
     * @param tmActivityId
     * @return
     */
    public boolean isEqualWithBacklogDetailInTaskIdAndActivityId(String tmTaskId, String tmActivityId) {
        return tmTaskId.equals(this.getTmTaskId()) && tmActivityId.equals(this.getTmActivityId());
    }

    /**
     * 当前任务卡是否支持转派，用于判断：app画面上是否会有转派功能
     *
     * @return
     */
    public boolean backlogHasReassignData() {
        return null != this.reassign && Boolean.TRUE.equals(this.reassign.get("reAssignAble"));
//                && ((Integer) this.reassign.get("reassignSize")) > 0;
    }
}
