package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

/**
 * <p>功能描述：任务类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcBacklogTypeEnum
 * @Author: Zaregoto
 * @Date: 2021/5/17 10:43
 */
public enum DigiwinAtmcBacklogTypeEnum {
    /**
     * 未知识类型的任务卡，仅移动端定义及使用
     */
    UNEXPECTED(-9999),

    /**
     * 正常类型的任务卡
     */
    NORMAL(1),

    /**
     * 逾期追踪类型的任务卡
     */
    OVERDUE_TRACK(88),
    /**
     * 问题确认
     */
    ANSWER_MAIN_ZERO(0),
//    ANSWER_MAIN_TWO(2),
    /**
     * 问题验收
     */
    ANSWER_ACCEPTANCE_ZERO(0),
//    ANSWER_ACCEPTANCE_TWO(2),
    /**
     * 问题确认、问题验收任务卡值为9
     */
    ANSWER_TYPE_NINE(9),
    ANSWER_TYPE_ONE(1),
    /**
     * 行事历任务卡
     */
    CALENDAR(72),
    /**
     * 团队行事历任务卡
     */
    TEAM_CALENDAR(71),
    /**
     * 交期回复、物料检查的type是11
     */
    REPLY_TASK(11);
    private final Integer value;

    DigiwinAtmcBacklogTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }
}
