package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：鼎捷雅典娜任务中心BPM任务工作内容项</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcBpmActivityWorkitem
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class DigiwinAtmcBpmActivityWorkitem implements Serializable {
    private static final long serialVersionUID = -802881419632976957L;

    private Long id;
    private Long activityStepId;
    // yyyy-MM-dd HH:mm:ss
    private String createTime;
    private String closedTime;

    private String performerId;
    private String performerName;

    private String workitemId;
    private String comment;


    //是否代理人执行，0-非代理人，1-代理人，2-辅助执行得
    private Integer performerType;

    /**
     * 0	未開始
     * 0	進行中
     * 0	暫停
     * 10	正常完成
     * 20	終止項目而關閉
     * 30	其他處理者已處理完成
     * 50	往前加簽而關閉
     * 60	退回重簽而關閉
     * 70	取回重辦而關閉
     * 80	由第三方強制終止項目而關閉
     * 90	項目被撤銷而關閉
     * 100	其他任務已處理完成而關閉
     * 110	因轉派而關閉
     * 120	因他人執行退回重簽而關閉
     * 130	因其他人執行往前加簽而關閉
     * 140	往後加簽而關閉
     * 150	因退回重辦而關閉
     * 160	因其他人執行退回重辦而關閉
     */
    private Integer subState;

    /**
     * 原逾期的workitem.Id
     */
    private Long overdueWorkitemId;

    /**
     * 类型，类型，1-普通，BPM的；11-辅助执行人的，88-逾时追踪
     */
    private Integer type;

    /**
     * 取值 0=正常产生/1=转派/2=退回重签/3=退回重办/4=加签
     */
    private Integer createType;

    /**
     * 特殊操作状态,空-无状态，reassign-转派,reexecute-退回重办,add-task-加签，abort-task-撤回，reapproval-退回重签
     */
    private String approvalState;

    /**
     * 1=转派/2=退回重签/4=加签等任务的来源任务workitemId
     */
    private String fromWorkitemId;

    /**
     * 任务合并后，所属分组ID
     * 值为 0 表示未合并
     */
    private Long groupId;

    /**
     * 目标租户，该工作项给哪个租户操作查看的
     * 该工作荐真正属于哪个租户，可以查看 bpmActivityStep.tenatnId
     */
    private String targetTenantId;

    /**
     * 重要性，我的最爱
     */
    private Integer importance;

    /**
     * 重要性的来源，如果来源是Athena，不能修改
     */
    private String importanceSource;

    /**
     * 协作厂商、企业用户的执行人ID
     */
    private String commonPerformerId;


    /**
     * 数据异动任务的历程里面的状态
     * 目前有：已提交，未提交两种状态
     */
    private String abnormalTaskState;
}
