package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：鼎捷Athena项目卡与任务卡摘要的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcCardDetail
 * @Author: Zaregoto
 * @Date: 2021/5/17 0:44
 */
public class DigiwinAtmcCardDetail implements Serializable {
    private static final long serialVersionUID = 8277623527909455402L;

    private Long backlogId;
    private DigiwinAtmcSummaryLayout summaryLayout;
    private List<DigiwinAtmcCheckTaskResultItem> todoItems;
    private List<DigiwinAtmcCheckTaskResultItem> checkItems;
    private String operation;
    private String projectId;
    private String tmTaskId;
    private Boolean overdue;

    public DigiwinAtmcCardDetail() {
    }

    public String getTaskContentMsg(String locale) {
        String itemUnitText = LocaleUtil.getMobileTextByKey(locale, "task-report-项");
        StringBuffer stringBuffer = new StringBuffer();
        for (DigiwinAtmcCheckTaskResultItem item : Optional.ofNullable(this.getTodoItems()).orElse(
                Collections.emptyList())) {
            if (item.getValue() != null) {
                stringBuffer.append(item.getValue()).append(itemUnitText).append(" ")
                        .append(item.getItem());
            } else if (item.getItem() != null) {
                stringBuffer.append(item.getItem());
            }
        }
        if (stringBuffer.length() == 0) {
            for (DigiwinAtmcCheckTaskResultItem item : Optional.ofNullable(this.getCheckItems()).orElse(
                    Collections.emptyList())) {
                if (item.getValue() != null) {
                    stringBuffer.append(item.getValue()).append(itemUnitText).append(" ")
                            .append(item.getItem());
                } else if (item.getItem() != null) {
                    stringBuffer.append(item.getItem()).append(" ");
                }
            }
        }
        if (this.getOperation() != null) {
            stringBuffer.append(this.getOperation());
        }
        return stringBuffer.toString();
    }

    public Long getBacklogId() {
        return backlogId;
    }

    public void setBacklogId(Long backlogId) {
        this.backlogId = backlogId;
    }

    public DigiwinAtmcSummaryLayout getSummaryLayout() {
        return summaryLayout;
    }

    public void setSummaryLayout(DigiwinAtmcSummaryLayout summaryLayout) {
        this.summaryLayout = summaryLayout;
    }

    public List<DigiwinAtmcCheckTaskResultItem> getTodoItems() {
        return todoItems;
    }

    public void setTodoItems(List<DigiwinAtmcCheckTaskResultItem> todoItems) {
        this.todoItems = todoItems;
    }

    public List<DigiwinAtmcCheckTaskResultItem> getCheckItems() {
        return checkItems;
    }

    public void setCheckItems(List<DigiwinAtmcCheckTaskResultItem> checkItems) {
        this.checkItems = checkItems;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getTmTaskId() {
        return tmTaskId;
    }

    public void setTmTaskId(String tmTaskId) {
        this.tmTaskId = tmTaskId;
    }

    public Boolean getOverdue() {
        return overdue;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }
}
