package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：团队项目中的团队成员树结构及相关信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcPersonnelStructure.java
 * @Author: wangjwc
 * @Date: created at 2024/7/30 11:55
 */
@Data
public class DigiwinAtmcPersonnelStructure implements Serializable {
    private static final long serialVersionUID = 1890029805693002191L;

    /**
     * 人员总数
     */
    private Integer membersTotal;
    /**
     * json人员树结构
     */
    private List<DigiwinEmp> data;
    /**
     * 默认选中人员
     */
    private List<DigiwinEmp> defaultSelectEmp;

    public List<DigiwinEmp> getAllChildrenDigiwinEmp() {
        List<DigiwinEmp> list = new ArrayList<>();
        getAllChildrenByParent(this.data, list);
        return list;
    }

    private void getAllChildrenByParent(List<DigiwinEmp> empList, List<DigiwinEmp> list) {
        empList.forEach(emp -> {
            if (CollectionUtils.isEmpty(emp.getChildren())) {
                list.add(emp);
            } else {
                getAllChildrenByParent(emp.getChildren(), list);
            }
        });
    }
}
