package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：打印模板信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcPrintTemplate.java
 * @Author: wangjwc
 * @Date: created at 2024/12/9 16:31
 */
@Data
public class DigiwinAtmcPrintTemplate implements Serializable {
    private static final long serialVersionUID = -7689457859259952007L;

    // 唯一标识
    private String uniqueId;
    // 模板关系类型   SYSTEM/TENANT_COPY/SYSTEM_EDIT
    private String type;
    // 租户id
    private String tenantId;
    // 作业code(项目/任务/基础资料)
    private String activityId;
    /**
     * 作业类型： 任务 BUSINESS_PERFORM  项目 BUSINESS_CHARGE   基础资料  DATA_ENTRY_PERFORM
     * @see com.digiwin.mobile.mobileuibot.printer.enums.PrinterTemplatePatternEnum
     */
    private String pattern;
    // 模板code
    private String code;
    // 模板id
    private String templateId;
    // 版本
    private String version;
    // 模板语系  "zh_TW": "繁中","zh_CN": "简中","en_US": "英文"
    private String locale;
    // 模板名称
    private String name;
    /**
     * API 入参 参数转换设定
     */
    private List<PcUiBotActionParameterMapping> actionParams;
}
