package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListOption;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷Athena中ATMC API响应的项目模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcProject
 * @Author: Zaregoto
 * @Date: 2021/4/25 21:49
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAtmcProject implements Serializable {
    private static final long serialVersionUID = -7647221986259004434L;
    //项目类型
    public static final String PROJECT_TYPE = "project_type";
    //项目状态
    public static final String PROJECT_STATUS = "project_status";

    //项目状态-异常/逾期
    public static final String PROJECT_STATUS_ABNORMAL = "project_status_abnormal";
    //项目状态-正常进行
    public static final String PROJECT_STATUS_NORMAL = "project_status_normal";
    //项目状态-紧急
    public static final String PROJECT_STATUS_URGENT = "project_status_urgent";
    //项目状态-暂无任务
    public static final String PROJECT_STATUS_NO_TASK = "project_status_no_task";
    //项目状态-他人分享
    public static final String PROJECT_STATUS_SHARE = "project_status_share";


    private Long id;
    private String name;
    private String startTime;
    private String endTime;
    private Boolean importance;
    private String createTime;
    private Integer taskCount;
    // 0-不紧急，1-紧急
    private Integer emergency;
    private Integer emergencyProjectCount;
    private Integer subProjectCount;
    private Integer subProjectFinishedCount;
    private Boolean changed;
    private Boolean isOwner;
    private String ownerUserId;
    private Long readCount;
    private String tmTaskId;
    private Boolean exception;
    private Boolean overdue;
    private String modifyDate;
    private Boolean hasDataChanged;
    private List<DigiwinAtmcTask> tasks;
    /**
     * 项目类型名称
     */
    private String projectName;
    private String personInCharge;
    private String personInChargeName;
    /**
     * 是否为被分享（web准确说是“钉选”功能，是项目卡“添加至他人athena”这个功能）
     */
    private Boolean pinning;

    /**
     * 应用名称
     */
    private String appCode;
    /**
     * 项目卡使用的引擎类型。示例：TaskEngine（表示任务引擎）
     */
    private String engineType;
    /**
     * 数据来源：PTM表示来源于PTM，其他表示ATMC
     */
    private String dataFrom;
    /**
     * 配置信息
     */
    private List<DigiwinAtmcCardConfigItem> cardConfig;

    private Map<String, Object> businessMessage;

    @Override
    public int hashCode() {
        // 参考：https://www.cnblogs.com/yuxiaole/p/9570850.html
        int result = 17;
        result = 31 * result + (id == null ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DigiwinAtmcProject) {
            DigiwinAtmcProject otherProject = (DigiwinAtmcProject) obj;
            return this.id.equals(otherProject.id);
        } else {
            return super.equals(obj);
        }
    }

    /**
     * 获取项目类型
     *
     * @return
     */
    public CardListFilter getProjectType(String locale) {
        CardListFilter filter = new CardListFilter();
        filter.setFilterId(PROJECT_TYPE);
        filter.setFilterName(LocaleUtil.getMobileTextByKey(locale, "项目类型"));
        List<CardListOption> optionList = new ArrayList<>();
        filter.setFilterOptionList(optionList);
        optionList.add(new CardListOption(this.getTmTaskId(), this.getProjectName()));
        return filter;
    }

    /**
     * 获取项目状态
     *
     * @param locale
     * @return
     */
    public CardListFilter getProjectStatus(String locale) {
        CardListFilter filter = new CardListFilter();
        filter.setFilterId(PROJECT_STATUS);
        filter.setFilterName(LocaleUtil.getMobileTextByKey(locale, "项目状态"));
        List<CardListOption> optionList = new ArrayList<>();
        filter.setFilterOptionList(optionList);

        if (this.getOverdue() || this.getException()) {
            optionList.add(new CardListOption(PROJECT_STATUS_ABNORMAL,
                    LocaleUtil.getMobileTextByKey(locale, "异常") + "/" + LocaleUtil.getMobileTextByKey(locale, "逾期")));
        } else {
            optionList.add(new CardListOption(PROJECT_STATUS_NORMAL, LocaleUtil.getMobileTextByKey(locale, "正常进行")));
        }
        if (this.getEmergency() != null && this.getEmergency() == 1) {
            optionList.add(new CardListOption(PROJECT_STATUS_URGENT, LocaleUtil.getMobileTextByKey(locale, "紧急")));
        }
        if (this.getTaskCount() != null && this.getTaskCount() == 0) {
            optionList.add(new CardListOption(PROJECT_STATUS_NO_TASK, LocaleUtil.getMobileTextByKey(locale, "暂无任务")));
        }
        if (this.getPinning() != null && this.getPinning()) {
            optionList.add(new CardListOption(PROJECT_STATUS_SHARE, LocaleUtil.getMobileTextByKey(locale, "他人分享")));
        }
        return filter;
    }

}
