package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜任务中心项目数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcProjectData
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class DigiwinAtmcProjectData implements Serializable {

    private static final long serialVersionUID = -7145246697628955674L;

    /**
     * 查询的项目sqlId
     */
    private Long projectId;

    private String projectName;

    /**
     * tm 任务ID
     */
    private String tmProjectId;

    /**
     * 租户信息
     */
    private String tenantId;


    // yyyy-MM-dd HH:mm:ss
    private String startTime;
    private String endTime;
    /**
     * 流程发起时间 yyyy-MM-dd HH:mm:ss
     */
    private String processCreateTime;
    /**
     * 来源
     */
    private List<Object> sourceIds;
    /**
     * 项目流程变量
     */
    private Map<String, Object> projectBpmData;
    /**
     * 项目卡的状态，是否关闭。值按照现有的定义，3表示已关闭
     */
    private Integer projectCardState;
    /**
     * projectCardId项目卡的Id，用于将来防重复提交
     */
    private Long projectCardId;
    /**
     * 当责者id
     */
    private String chargeId;
}
