package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wuyang
 * 聚合搜索的结果（不包含知识中台的）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAtmcSearchResult implements Serializable {

    private static final long serialVersionUID = -8618685948834543416L;

    private String code;
    private String endTime;
    private String engineType;
    private Long id;
    private String name;
    private String startTime;
    /**
     * 1：未完成，0、2：已完成
     */
    private String state;
    /**
     * 0：项目 1：任务 2：发起项目
     */
    private String type;
    private String tmTaskId = "";
    private String projectDefCode = "";
    private String taskDefCode = "";
    private String taskDefPattern = "";
    private String taskDefCategory = "";
    private String tmActivityId = "";
    private String tmPattern = "";
    private String tmCategory = "";

    public void setProjectDefCode(String projectDefCode) {
        this.projectDefCode = projectDefCode;
        this.tmTaskId = projectDefCode;
    }

    public void setTaskDefCode(String taskDefCode) {
        this.taskDefCode = taskDefCode;
        this.tmActivityId = taskDefCode;
    }

    public void setTaskDefPattern(String taskDefPattern) {
        this.taskDefPattern = taskDefPattern;
        this.tmPattern = taskDefPattern;
    }


    public void setTaskDefCategory(String taskDefCategory) {
        this.taskDefCategory = taskDefCategory;
        this.tmCategory = taskDefCategory;
    }
}
