package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>功能描述：任务卡卡面摘要的数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcTaskCardDetail
 * @Author: Zaregoto
 * @Date: 2022/3/24 0:48
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAtmcTaskCardAbstract implements Serializable {
    private static final long serialVersionUID = 327292680348819298L;

    private Long backlogId;
    /**
     * 任务卡卡面摘要。
     * eg:1235-202203010001<br>浩浩
     * eg:请购单单号：0876-202203230003,0876-202203230001
     */
    private String summaryLayout;
    /**
     * 待处理。
     * eg：待处理0项
     */
    private String todoItems;
    private String checkItems;
    private String operation;
    private String historyMessage;
    // 根据cardState返参，前端根据此回参数信息对卡片标签进行渲染
    private List<String> cardState;

    public String getTaskContentMsg() {
        if (null != this.summaryLayout) {
            return this.summaryLayout.replace("<br>", "；");
        }
        if (null != this.todoItems) {
            return this.todoItems;
        }
        if (null != this.checkItems) {
            return this.checkItems;
        }
        return "";
    }

    public String getAbnormaContentMsg() {
        if (null != this.checkItems) {
            return this.checkItems.replace("<br>", " ");
        }
        return "";
    }

    public List<String> getTaskContentMsgList() {
        String msg = "";
        if (null != this.summaryLayout) {
            msg = summaryLayout;
        } else if (null != this.todoItems) {
            msg = todoItems;
        } else if (null != this.checkItems) {
            msg = checkItems;
        }
        return StringUtils.hasLength(msg) ? Arrays.asList(msg.split("<br>")) : new ArrayList<>();
    }
}
