package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcTaskProcessWorkItem
 * @Author: Zaregoto
 * @Date: 2021/5/21 20:02
 */
@Data
public class DigiwinAtmcTaskProgressWorkItem implements Serializable {
    private static final long serialVersionUID = -7763135230765374703L;

    private Long id;
    private Long activityStepId;
    // YYYY-MM-DD HH:MM:SS
    private String createTime;
    // YYYY-MM-DD HH:MM:SS
    private String closedTime;
    private String performerId;
    private String performerName;
    private String workitemId;
    private String comment;
    private Integer state;
    private List<DigiwinAtmcTaskProgressWorkItemReassign> reassign;
    // YYYY-MM-DD HH:MM:SS
    private String rowCreateTime;
    private String agentPerformerId;
    private String agentPerformerName;
    /**
     * 0-原执行人执行
     * 1-代理人执行
     * 2-辅助执行者执行
     * 998-服务授权代理人执行
     * 999-外部使用、超级管理员
     */
    private Integer performerType;

    /**
     * 0	未開始
     * 0	進行中
     * 0	暫停
     * 10	正常完成
     * 20	終止項目而關閉
     * 30	其他處理者已處理完成
     * 50	往前加簽而關閉
     * 60	退回重簽而關閉
     * 70	取回重辦而關閉
     * 80	由第三方強制終止項目而關閉
     * 90	項目被撤銷而關閉
     * 100	其他任務已處理完成而關閉
     * 110	因轉派而關閉
     * 120	因他人執行退回重簽而關閉
     * 130	因其他人執行往前加簽而關閉
     * 140	往後加簽而關閉
     * 150	因退回重辦而關閉
     * 160	因其他人執行退回重辦而關閉
     */
    private Integer subState;
    /**
     * 附件
     */
    List<DigiwinAtmcTaskProgressWorkItemAttachment> attachments;
    //任务状态
    public Integer createType;
}
