package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * <p>功能描述：鼎捷雅典娜任务中心任务与backlog数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcTaskWithBacklogData
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAtmcTaskWithBacklogData implements Serializable {
    private static final long serialVersionUID = -5304718034310329048L;

    /**
     * bpm 参数数据
     */
    private Map<String, Object> bpmData;

    private JSONObject stateData;

    private Map<String, Object> businessUnit;

    private List<String> eocName;

    private String tmActivityId;

    private String tmActivityName;

    private String tmCategory;

    private String tmPattern;
    /**
     * bpm 活动ID
     */
    private String bpmActivityId;

    /**
     * 代理token
     */
    private String proxyToken;
    /**
     * 流程实例编号
     */
    private String processSerialNumber;


    /**
     * BMP - 活动类型
     */
    private String bpmActivityType;

    /**
     * 执行责 ID
     */
    private List<String> performerIds;

    /**
     * 任务的审核详细步骤
     */
    private List<DigiwinAtmcBpmActivityStepDTO> steps;

    /**
     * 签核状态
     */
    private String approvalState;

    /**
     * 签核状态(用于显示退回意见)
     */
    private String isRapprovalInfoShow;
    /**
     * backlog 数据
     */
    private List<DigiwinAtmcBacklogData> backlog;

    /**
     * 支持撤回的主键表列
     */
    private JSONArray abortDataKeys;

    /**
     * 关联的签核信息
     */
    private Map<String, Object> relationApproval;

    /**
     * 调用链ID
     */
    private String traceId;

    /**
     * taskUid，任务引擎才会有
     */
    private String taskUid;

    /**
     * 回复型任务注册邀请信息
     */
    private Map replyInvite;

    /**
     * 数据异动任务需要使用的字段
     */
    private DigiwinAtmcBpmActivityWorkitem abnormalTaskInfo;

    public DigiwinAtmcTaskWithBacklogData copy() {
        return JsonUtil.objectToJavaObject(this, DigiwinAtmcTaskWithBacklogData.class);
    }
}
