package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 获取报表的分类信息（DCP、PCC、DCC等）
 *
 * @author zhangjj
 * @date 2022/4/12 3:10 PM
 */
@Data
public class DigiwinAtmcTmData {

    private String appCode;
    private String appName;
    private List<DigiwinAtmcTmDataReport> baseItemDtoList;
    private List<DigiwinAtmcTmDataGroup> groupList;
    private String tier;

    public List<DigiwinAtmcTmDataReport> getBaseItemDtoList() {
        baseItemDtoList = Optional.ofNullable(this.baseItemDtoList).orElse(new ArrayList<>());
        if (CollectionUtils.isNotEmpty(groupList)) {
            baseItemDtoList.addAll(this.groupList.stream()
                    .map(item -> item.getBaseItemDtoList())
                    .flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return baseItemDtoList;
    }

    public List<DigiwinAtmcTmDataGroup> getGroupList() {
        return groupList = Optional.ofNullable(this.groupList).orElse(new ArrayList<>());
    }
}
