package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 报表Item
 *
 * @author zhangjj
 * @date 2022/4/12 3:11 PM
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAtmcTmDataReport {

    private String name;
    private String code;
    /**
     * tbb的code对应是tbb的key，实际是一串uid
     * 但code应该是需要具有可读性的，不应该直接和某个key直接绑定
     * tbb的配置需要增加栏位（新增resCode），关联tbb报表的key，让code回归原有的含义
     */
    private String resCode;
    private String category;
    private String appCode;
    private String appName;
    private boolean commonUsed;
    private boolean ifCommon;
    private boolean ifCustom;
    private String access;
    private Long itemId;
    // 图标
    private String icon;

    /**
     * 判断是否有权限
     *
     * @return
     */
    public Boolean isAllow() {
        return "allow".equalsIgnoreCase(access);
    }
}
