package com.digiwin.mobile.mobileuibot.proxy.atmc.service;

import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>功能描述：鼎捷ATMC系统代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcProxyService
 * @Author: Zaregoto
 * @Date: 2021/4/20 20:52
 */
public interface DigiwinAtmcProxyService {

    String API_PREFIX = "/api/atmc/v1";

    List<DigiwinAtmcBacklog> listMyBacklog(String clientId, String locale, String iamUserToken, String tenantId)
            throws IOException;

    /**
     * 获取项目列表
     *
     * @param clientId
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     * @throws IOException
     */
    List<DigiwinAtmcProject> listMyProject(String clientId, String locale, String iamUserToken, String tenantId) throws IOException;

    DigiwinAtmcProject getDigiwinAtmcProjectByAimMessage(String locale, String iamUserToken,
                                                         String aimMessageContentId, String aimMessageType);

    @Deprecated
    DigiwinAtmcProjectCheckTaskResult getDigiwinAtmcProjectTaskCheckResult(String locale, String iamUserToken,
                                                                           String projectId, String tmActivityId);

    DigiwinAtmcBacklogImportanceSetResult setDigiwinAtmcBacklogImportance(String locale, String iamUserToken, String tenantId,
                                                                          String dataId, String importance);

    @Deprecated
    DigiwinAtmcCardDetail getDigiwinAtmcBacklogCardDetail(String locale, String iamUserToken, String dataId);

    DigiwinAtmcTaskCardAbstract getDigiwinAtmcBacklogCardAbstract(String locale, String iamUserToken, String tenantId, String dataId, String proxyToken);

    /**
     * 更新Athena任务详情阅读次数（这里backlog指任务）
     *
     * @param locale       语言别
     * @param iamUserToken
     * @param tenantId     租户id
     * @param dataId       任务卡id
     * @return
     */
    DigiwinAtmcBacklogReadCount updateDigiwinAtmcBacklogReadCount(String locale, String iamUserToken, String tenantId, String dataId);

    DigiwinAtmcBacklogDetail getDigiwinAtmcBacklogDetail(String locale, String iamUserToken, String tenantId, String dataId);

    DigiwinAtmcBacklogDetail getDigiwinAtmcBacklogDetailByShare(String locale, String iamUserToken, String dataId);

    DigiwinAtmcBacklogSubmitResult actionSubmit(String locale, String iamUserToken, String tenantId, Map<String, Object> requestData);

    List<DigiwinAtmcTaskProgress> getApprovalTaskSignoffProgress(String locale, String iamUserToken, String tenantId, Map<String, Object> requestData);

    /**
     * 获取项目卡的任务摘要数据
     *
     * @param locale
     * @param iamUserToken
     * @param projectId
     * @return
     */
    DigiwinAtmcCardDetail getDigiwinAtmcProjectCardDetail(String locale, String iamUserToken, String tenantId, String projectId);

    /**
     * 更新Athena项目详情阅读次数（这里task指项目）
     *
     * @param locale       语言别
     * @param iamUserToken
     * @param tenantId     租户id
     * @param dataId       项目卡id
     * @return
     */
    DigiwinAtmcTaskReadCount updateDigiwinAtmcTaskReadCount(String locale, String iamUserToken, String tenantId, String dataId);

    /**
     * 通过项目ID获得项目
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param dataId
     * @return
     */
    DigiwinAtmcPanel getTaskPanel(String locale, String iamUserToken, String tenantId, String dataId);

    /**
     * 获取该项目下所有关联的任务
     *
     * @param projectId
     * @param iamUserToken
     * @param locale
     * @return
     */
    List<DigiwinAtmcTask> getTaskListByProjectId(String projectId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取通知消息下跳转的任务卡
     *
     * @param shareCode
     * @return
     * @throws IOException
     */
    DigiwinAtmcTaskShare getShareTask(String locale, String iamUserToken, String shareCode);

//    /**
//     * 获取所有报表
//     *
//     * @param iamUserToken
//     * @param tenantId
//     * @param locale
//     * @return
//     */
//    List<DigiwinAtmcTmData> getTmDataList(String clientId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取所有行事历
     *
     * @param iamUserToken
     * @param locale
     * @return
     */
    List<DigiwinAtmcCalendar> queryAllTeamMember(String iamUserToken, String locale);

    /**
     * 获取行事历下所有成员的任务
     *
     * @param clientId
     * @param iamUserToken
     * @param teamId
     * @param locale
     * @param startDate    开始时间
     * @param endDate      结束时间
     * @return
     */
    List<DigiwinAtmcBacklog> getTeamMemberWorkItemList(String clientId, String iamUserToken, String teamId, String locale,
                                                       String startDate, String endDate);

    /**
     * 获取标准项目详情（鼎华的应用使用过的项目）（通过项目id获取）
     *
     * @param taskId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    DigiwinAtmcEnginePanelInfo getEnginePanelInfoByTaskId(String taskId, String clientId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取项目来源信息
     */
    Map<String, DigiwinAtmcPanelSource> getSourcesByMainTaskId(String taskId, String clientId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取聚合搜索的结果（不包含知识中台的）
     *
     * @param iamUserToken
     * @param locale
     * @param name
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcSearchResult> getSearchResult(String iamUserToken, String locale, String name, String tenantId);

    /**
     * 获取聚合搜索任务的结果
     *
     * @param iamUserToken
     * @param locale
     * @param queryParam
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcSearchTaskResult> getSearchTaskResult(String iamUserToken, String locale, String queryParam, String tenantId);

    /**
     * 搜索项目
     *
     * @param queryParam
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<String> projectSearch(String queryParam, String iamUserToken, String tenantId, String locale, String clientId);

    /**
     * 搜索团队项目
     *
     * @param queryParam
     * @param personnelStructures
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<String> teamProjectSearch(String queryParam, List<DigiwinEmp> personnelStructures, String iamUserToken, String tenantId, String locale, String clientId);

    /**
     * 搜索任务
     *
     * @param queryParam
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    Set<String> taskSearch(String queryParam, String iamUserToken, String tenantId, String locale, String clientId);

    /**
     * 团队项目中的团队成员树结构及相关信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    DigiwinAtmcPersonnelStructure getPersonnelStructure(String iamUserToken, String tenantId, String locale);

    /**
     * 获取团队成员的项目
     *
     * @param empProject
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcProject> selectEmpProject(List<DigiwinEmp> empProject, String iamUserToken, String locale, String tenantId);

    /**
     * 根据项目卡id，查询该项目所有任务及执行人信息。
     *
     * @param projectId
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcBacklogPerformer> getPerformerListByProjectId(String projectId, String iamUserToken,
                                                                  String locale, String tenantId);

    /**
     * 根据任务ID，找到该任务所属项目卡的当责者
     *
     * @param backLogId
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcProjectPerformer> getPerformerListByBackLogId(String backLogId, String iamUserToken,
                                                                  String locale, String tenantId);

    /**
     * 获取任务卡转派记录
     *
     * @param taskId
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return
     */
    List<DigiwinReassignReport> getTaskReassignReport(String taskId, String iamUserToken,
                                                      String locale, String tenantId);

    /**
     * 获取项目卡转派记录
     *
     * @param projectId
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return
     */
    List<DigiwinReassignReport> getProjectReassignReport(String projectId, String iamUserToken,
                                                         String locale, String tenantId);

    /**
     * 获取任务卡可转派的用户列表
     * 已过滤「无应用授权」及「停用」人员,当前登录人
     *
     * @param atmcBacklogDetail
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcReassignUser> batchGetTaskReassignUsers(DigiwinAtmcBacklogDetail atmcBacklogDetail, String iamUserToken, String locale, String tenantId);

    /**
     * 获取项目卡可转派的用户列表
     * 已过滤「无应用授权」及「停用」人员,当前登录人
     *
     * @param projectDetail
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcReassignUser> batchGetProjectReassignUsers(DigiwinAtmcPanelTask projectDetail, String iamUserToken, String locale, String tenantId);

    /**
     * 添加至他人Athena
     *
     * @param appCode
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @return List<DigiwinAtmcReassignUser>
     * @author yanfeng
     */
    List<DigiwinAtmcReassignUser> getEligibleUserList(String appCode, String iamUserToken, String locale, String tenantId);

    /**
     * 转派的提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean reassignSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 分享至他人的提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean insertTaskPinning(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 发起项目:智慧检料提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean intelligentMaterialInspectionProject(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 根据报表的activityCode得到其常用条件
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param activityCode
     * @return
     */
    List<Map<String, Object>> conditionQueryInBi(String iamUserToken, String tenantId, String locale, String activityCode);

    /**
     * 项目卡分组
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param groupType
     * @return
     */
    List<DigiwinAtmcProjectGroup> getDepartProjectGroup(String iamUserToken, String tenantId, String locale, String groupType);

    /**
     * 任务卡分组
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param groupType
     * @return
     */
    List<DigiwinAtmcBacklogGroup> getDepartBacklogGroup(String iamUserToken, String tenantId, String locale, String groupType);

    /**
     * 根据分组获取任务卡列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<DigiwinAtmcBacklog> getDepartBacklogGroupList(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 根据分组获取项目卡列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<DigiwinAtmcProject> getDepartProjectGroupList(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 获取ABI报表的查询的缓存key
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    String getAbiDataCache(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 删除ABI报表的常用条件
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean deleteAbiCondition(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 保存ABI报表的常用条件
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @param conditionName
     * @return
     */
    Map<String, Object> saveAbiCondition(String iamUserToken, String tenantId, String locale, Map<String, Object> params, String conditionName);

    /**
     * 项目--获取ATMC数据
     *
     * @param taskId
     * @param pageContext
     * @return
     */
    DigiwinAtmcActivityData getProjectData(String taskId, PcUiBotExecuteContext pageContext);

    /**
     * 任务--获取ATMC数据
     *
     * @param backlogId
     * @param executeContext
     * @return
     */
    DigiwinAtmcActivityData getTaskData(String backlogId, PcUiBotExecuteContext executeContext);

    /**
     * 流程进度
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param params
     * @return
     */
    DigiwinAtmcWorkflowProgressHistory getApprovalWorkflowHistory(String locale, String iamUserToken, String tenantId, Map<String, Object> params);

    /**
     * 任务卡关注和取消关注
     *
     * @param backlogId
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param importanceValue 0：取消关注；1：关注
     * @return
     */
    Boolean backlogImportance(String backlogId, String locale, String iamUserToken, String tenantId, String importanceValue);

    /**
     * 分享任务卡取消查看
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param params
     * @return
     */
    Boolean cancelPinning(String locale, String iamUserToken, String tenantId, Map<String, Object> params);

    /**
     * 查询排序展示条件
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    Map<String, Object> getBacklogRuleDisplay(String locale, String iamUserToken, String tenantId);

    /**
     * 根据BK查询卡片信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    DigiwinAtmcDomain domainSearch(String locale, String iamUserToken, String tenantId, Map<String, Object> params);

    /**
     * 根据backlogId的集合获取任务列表信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcBacklog> getBacklogListByIds(String locale, String iamUserToken, String tenantId, List<String> backlogIdList);

    /**
     * 获取排序信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcOrderSetting> getOrderTaskSetting(String locale, String iamUserToken, String tenantId);

    /**
     * 获取筛选信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcFilterSetting> getFilterTaskSetting(String locale, String iamUserToken, String tenantId);

    /**
     * 获取打印模板列表
     */
    List<DigiwinAtmcPrintTemplate> getPrintList(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 获取打印ABI数据
     */
    DigiwinAtmcPrintAbiData getPrintAbiData(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 获取指定任务的调试信息
     */
    List<List<DigiwinAtmcTaskDebugger>> getTaskDebugger(String locale, String iamUserToken, String tenantId, Long workitemId);
}
