package com.digiwin.mobile.mobileuibot.proxy.atmc.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAtmcProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/4/20 20:57
 */
@Service("digiwinAtmcProxyService")
public class DigiwinAtmcProxyServiceImpl implements DigiwinAtmcProxyService {

    private static final Logger logger = LoggerFactory.getLogger(DigiwinAtmcProxyServiceImpl.class);

    private final HttpService httpService;
    @Autowired
    private TaskFilterService taskFilterService;
    @Autowired
    private ProjectFilterService projectFilterService;

    public DigiwinAtmcProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public List<DigiwinAtmcBacklog> listMyBacklog(String clientId, String locale, String iamUserToken, String tenantId) throws IOException {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/list?clientId={clientId}";

        Map<String, String> uriVariables = new HashMap<>(1);
        uriVariables.put("clientId", clientId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        uriVariables, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAtmcProject> listMyProject(String clientId, String locale,
                                                  String iamUserToken, String tenantId) throws IOException {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/list?clientId={clientId}";

        Map<String, String> uriVariables = new HashMap<>(1);
        uriVariables.put("clientId", clientId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), uriVariables, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public DigiwinAtmcProject getDigiwinAtmcProjectByAimMessage(String locale, String iamUserToken,
                                                                String aimMessageContentId, String aimMessageType) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/getMainTaskById" + "/" + aimMessageContentId + "/" + aimMessageType;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcProject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcProject>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcProject>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcProject();
    }

    @Override
    public DigiwinAtmcProjectCheckTaskResult getDigiwinAtmcProjectTaskCheckResult(String locale,
                                                                                  String iamUserToken, String projectId, String tmActivityId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/list/card" + "/" + projectId + "/" + tmActivityId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcProjectCheckTaskResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcProjectCheckTaskResult>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcProjectCheckTaskResult>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcProjectCheckTaskResult();
    }

    @Override
    public DigiwinAtmcBacklogImportanceSetResult setDigiwinAtmcBacklogImportance(String locale,
                                                                                 String iamUserToken, String tenantId,
                                                                                 String dataId, String importance) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/" + dataId + "/importance/" + importance;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogImportanceSetResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogImportanceSetResult>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcBacklogImportanceSetResult>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        // TODO 因该接口返回数据没有对象实体，只有通用api参数，所以借用对应的状态码
        DigiwinAtmcBacklogImportanceSetResult result = new DigiwinAtmcBacklogImportanceSetResult();
        result.setStatus(statusCode.value());
        return result;
    }

    @Override
    public DigiwinAtmcCardDetail getDigiwinAtmcBacklogCardDetail(
            String locale, String iamUserToken, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/list/card/" + dataId;

        // 任务卡详情数据
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcCardDetail>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcCardDetail>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcCardDetail>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcCardDetail();
    }

    @Override
    public DigiwinAtmcTaskCardAbstract getDigiwinAtmcBacklogCardAbstract(String locale, String iamUserToken,
                                                                         String tenantId, String dataId, String proxyToken) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/abstract/" + dataId;

        // 任务卡详情数据
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcTaskCardAbstract>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcTaskCardAbstract>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcTaskCardAbstract>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId, proxyToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcTaskCardAbstract();
    }

    @Override
    public DigiwinAtmcBacklogReadCount updateDigiwinAtmcBacklogReadCount(String locale, String iamUserToken,
                                                                         String tenantId, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/readCount/" + dataId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogReadCount>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogReadCount>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcBacklogReadCount>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        // TODO 因该接口返回数据没有对象实体，只有通用api参数，所以借用对应的状态码
        DigiwinAtmcBacklogReadCount result = new DigiwinAtmcBacklogReadCount();
        result.setStatus(statusCode.value());
        return result;
    }

    @Override
    public DigiwinAtmcBacklogDetail getDigiwinAtmcBacklogDetail(String locale, String iamUserToken,
                                                                String tenantId, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/detail/" + dataId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogDetail>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogDetail>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcBacklogDetail>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcBacklogDetail();
    }

    @Override
    public DigiwinAtmcBacklogDetail getDigiwinAtmcBacklogDetailByShare(String locale, String iamUserToken, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/detail/" + dataId + "?isShared=true";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogDetail>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogDetail>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcBacklogDetail>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcBacklogDetail();
        return digiwinAtmcBacklogDetail;
    }

    @Override
    public DigiwinAtmcBacklogSubmitResult actionSubmit(String locale, String iamUserToken, String tenantId,
                                                       Map<String, Object> requestData) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/action/submit";

        String proxyToken = "";
        if (requestData != null && requestData.get("digi-proxy-token") != null) {
            proxyToken = (String) requestData.get("digi-proxy-token");
        }
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogSubmitResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcBacklogSubmitResult>>() {
                };
        logger.error("submit统一提交参数: {}", JsonUtil.javaObjectToJsonString(requestData));
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcBacklogSubmitResult>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId, proxyToken),
                        JsonUtil.javaObjectToJsonString(requestData), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcBacklogSubmitResult(statusCode.value(), responseEntity.getBody().getErrorMessage());
    }

    @Override
    public List<DigiwinAtmcTaskProgress> getApprovalTaskSignoffProgress(String locale, String iamUserToken,
                                                                        String tenantId, Map<String, Object> requestData) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/approval/task";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTaskProgress>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTaskProgress>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcTaskProgress>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(requestData), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public DigiwinAtmcCardDetail getDigiwinAtmcProjectCardDetail(String locale, String iamUserToken, String tenantId, String projectId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/list/card/" + projectId;

        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcCardDetail>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcCardDetail>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcCardDetail>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcCardDetail();
    }

    @Override
    public DigiwinAtmcTaskReadCount updateDigiwinAtmcTaskReadCount(String locale, String iamUserToken,
                                                                   String tenantId, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/readCount/" + dataId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcTaskReadCount>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcTaskReadCount>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcTaskReadCount>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        // TODO 因该接口返回数据没有对象实体，只有通用api参数，所以借用对应的状态码
        DigiwinAtmcTaskReadCount result = new DigiwinAtmcTaskReadCount();
        result.setStatus(statusCode.value());
        return result;
    }

    @Override
    public DigiwinAtmcPanel getTaskPanel(String locale, String iamUserToken, String tenantId, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/panel/" + dataId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPanel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPanel>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcPanel>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : DigiwinAtmcPanel.createEmpty();
    }

    @Override
    public List<DigiwinAtmcTask> getTaskListByProjectId(String projectId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/" + projectId + "/tasklist";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTask>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTask>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcTask>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public DigiwinAtmcTaskShare getShareTask(String locale, String iamUserToken, String shareCode) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/share/task?sharingCode=" + shareCode;
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcTaskShare>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcTaskShare>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcTaskShare>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcTaskShare();
    }

//    @Override
//    public List<DigiwinAtmcTmData> getTmDataList(String clientId, String iamUserToken, String tenantId, String locale) {
//        String url = AppContext.getApiUrlSetting().getAtmcUrl()
//                + "/api/amtc/v1/commonUsed/tmDataList?plat=1";
//        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTmData>>> responseType =
//                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTmData>>>() {
//                };
//        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcTmData>>> responseEntity =
//                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);
//
//        HttpStatus statusCode = responseEntity.getStatusCode();
//        return statusCode.is2xxSuccessful() ?
//                responseEntity.getBody().getResponse() : new ArrayList<>();
//
//    }

    @Override
    public List<DigiwinAtmcCalendar> queryAllTeamMember(String iamUserToken, String locale) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/calendar/team/queryAllTeamMember";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcCalendar>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcCalendar>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcCalendar>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new ArrayList<>();
    }

    @Override
    public List<DigiwinAtmcBacklog> getTeamMemberWorkItemList(
            String clientId, String iamUserToken, String teamId, String locale,
            String startDate, String endDate) {
        /**
         * FIXME completed=false是可选字段，但移动端目前需要给false值，让后台SmartData过滤掉已完成的行事历任务，否则会有性能问题。
         * 若未来对行事历的展示有整体优化，则可以再将此参数改为true。
         * 接口文档地址：http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#6449cf4ea5a497000b26afaf
         */
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/calendar/team/member/workitem/list?completed=false&teamId=" + teamId + "&clientId=" + clientId;
        if (StringUtils.hasLength(startDate) && StringUtils.hasLength(endDate)) {
            url = url + "&startDate=" + startDate + "&endDate=" + endDate;
        }

        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new ArrayList<>();
    }

    @Override
    public DigiwinAtmcEnginePanelInfo getEnginePanelInfoByTaskId(String taskId, String clientId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/panel/taskEnginePanelInfo?taskId=" + taskId;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcEnginePanelInfo>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcEnginePanelInfo>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcEnginePanelInfo>> responseEntity
                = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcEnginePanelInfo();
    }

    @Override
    public Map<String, DigiwinAtmcPanelSource> getSourcesByMainTaskId(String taskId, String clientId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/panel/getSourcesByMainTaskId?taskId=" + taskId;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, DigiwinAtmcPanelSource>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, DigiwinAtmcPanelSource>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, DigiwinAtmcPanelSource>>> responseEntity
                = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new HashMap<>();
    }

    @Override
    public List<DigiwinAtmcSearchResult> getSearchResult(String iamUserToken, String locale, String name, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/search/result";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcSearchResult>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcSearchResult>>>() {
                };
        Map<String, String> params = new HashMap<>(1);
        params.put("name", name);
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcSearchResult>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAtmcSearchTaskResult> getSearchTaskResult(String iamUserToken, String locale, String queryParam, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/mobile/search/backlog/by/param";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcSearchTaskResult>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcSearchTaskResult>>>() {
                };
        Map<String, String> params = new HashMap<>(1);
        params.put("queryParam", queryParam);
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcSearchTaskResult>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<String> projectSearch(String queryParam, String iamUserToken, String tenantId, String locale, String clientId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/taskActivityMessage/findProjectCardIdByParam?queryParam=" + queryParam;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Long>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Long>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<Long>>> responseEntity
                = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return new ArrayList<>();
        }
        List<Long> idList = responseEntity.getBody().getResponse();
        if (CollectionUtils.isEmpty(idList)) {
            return new ArrayList<>();
        }
        return idList.stream().map(StringUtil::valueOf).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> teamProjectSearch(String queryParam, List<DigiwinEmp> personnelStructures, String iamUserToken, String tenantId, String locale, String clientId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/taskActivityMessage/findTeamProjectCardIdByParam";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Long>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Long>>>() {
        };
        Map<String, Object> params = new HashMap<>(1);
        params.put("queryParam", queryParam);
        params.put("personnelStructures", personnelStructures);
        ResponseEntity<DigiwinAthenaApiResponse<List<Long>>> responseEntity
                = this.httpService.doPost(url,
                new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                JsonUtil.javaObjectToJsonString(params), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return new ArrayList<>();
        }
        List<Long> idList = responseEntity.getBody().getResponse();
        if (CollectionUtils.isEmpty(idList)) {
            return new ArrayList<>();
        }
        return idList.stream().map(StringUtil::valueOf).distinct().collect(Collectors.toList());
    }

    @Override
    public Set<String> taskSearch(String queryParam, String iamUserToken, String tenantId, String locale, String clientId) {
        Set<String> ids = new HashSet<>();
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/taskActivityMessage/findTaskCardIdByParam?queryParam=" + queryParam;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Long>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Long>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<Long>>> responseEntity
                = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return ids;
        }
        List<Long> idList = responseEntity.getBody().getResponse();
        if (CollectionUtils.isEmpty(idList)) {
            return ids;
        }
        idList.forEach(id -> {
            ids.add(id.toString());
        });
        return ids;
    }

    @Override
    public DigiwinAtmcPersonnelStructure getPersonnelStructure(String iamUserToken, String tenantId,
                                                               String locale) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/departmentProject/personnelStructure";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPersonnelStructure>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPersonnelStructure>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcPersonnelStructure>> responseEntity
                = this.httpService.doGet(url,
                new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
        ) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<DigiwinAtmcProject> selectEmpProject(List<DigiwinEmp> empProject, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/depart/selectEmpProject";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(empProject), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAtmcBacklogPerformer> getPerformerListByProjectId(String projectId, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/project/tasks/" + projectId;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklogPerformer>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklogPerformer>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklogPerformer>>> responseEntity
                = this.httpService.doGet(url,
                new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
                || responseEntity.getBody().getResponse().size() < 1
        ) {
            List<DigiwinAtmcBacklogPerformer> test = new ArrayList<>(1);
            DigiwinAtmcBacklogPerformer digiwinAtmcBacklogPerformer = new DigiwinAtmcBacklogPerformer();
            digiwinAtmcBacklogPerformer.setBacklogId(238429763920064L);
            digiwinAtmcBacklogPerformer.setNeteaseImAccId("test_cnhw_623");
            digiwinAtmcBacklogPerformer.setPerformerId("pur003");
            digiwinAtmcBacklogPerformer.setPerformerName("采购主管1");
            digiwinAtmcBacklogPerformer.setTaskName("工艺委外叫料计划");
            test.add(digiwinAtmcBacklogPerformer);
            return test;

//            return Collections.emptyList();
        } else {
            return responseEntity.getBody().getResponse();
        }
    }

    @Override
    public List<DigiwinAtmcProjectPerformer> getPerformerListByBackLogId(String backLogId, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/personInCharges/" + backLogId;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProjectPerformer>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProjectPerformer>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcProjectPerformer>>> responseEntity
                = this.httpService.doGet(url,
                new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
                || responseEntity.getBody().getResponse().size() < 1
        ) {
            List<DigiwinAtmcProjectPerformer> test = new ArrayList<>(1);
            DigiwinAtmcProjectPerformer performer = new DigiwinAtmcProjectPerformer();
            performer.setPersonInCharge("pur003");
            performer.setNeteaseImAccId("test_cnhw_623");
            performer.setPersonInChargeName("采购主管1");
            performer.setProjectCardId(238429763920064L);
            performer.setProjectCardName("工艺委外叫料计划");
            test.add(performer);
            return test;
//            return Collections.emptyList();
        } else {
            return responseEntity.getBody().getResponse();
        }
    }

    @Override
    public List<DigiwinReassignReport> getTaskReassignReport(String taskId, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/reassign/report/TASK/" + taskId;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinReassignReport>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinReassignReport>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinReassignReport>>> responseEntity
                = this.httpService.doGet(url,
                new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
        ) {
            return Collections.emptyList();
        } else {
            return responseEntity.getBody().getResponse();
        }
    }

    @Override
    public List<DigiwinReassignReport> getProjectReassignReport(String projectId, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/reassign/report/PROJECT/" + projectId;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinReassignReport>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinReassignReport>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinReassignReport>>> responseEntity
                = this.httpService.doGet(url,
                new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
        ) {
            return Collections.emptyList();
        } else {
            return responseEntity.getBody().getResponse();
        }
    }

    @Override
    public List<DigiwinAtmcReassignUser> batchGetTaskReassignUsers(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/reassign/batchUsers";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>>() {
                };

        Map<String, Object> requestPayload = new HashMap<>(3);
        requestPayload.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
        requestPayload.put("category", "TASK");
        requestPayload.put("list", Collections.singletonList(digiwinAtmcBacklogDetail));

        return getDigiwinAtmcReassignUsers(iamUserToken, locale, tenantId, url, responseType, requestPayload);
    }

    @Override
    public List<DigiwinAtmcReassignUser> batchGetProjectReassignUsers(DigiwinAtmcPanelTask projectDetail, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/reassign/batchUsers";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>>() {
                };

        Map<String, Object> requestPayload = new HashMap<>(3);
        requestPayload.put("appCode", projectDetail.getAppCode());
        requestPayload.put("category", "PROJECT");
        requestPayload.put("list", Collections.singletonList(projectDetail));

        return getDigiwinAtmcReassignUsers(iamUserToken, locale, tenantId, url, responseType, requestPayload);
    }

    @Override
    public List<DigiwinAtmcReassignUser> getEligibleUserList(String appCode, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/user/eligible";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>>() {
                };

        Map<String, Object> requestPayload = new HashMap<>(2);
        if (!"null".equalsIgnoreCase(appCode)) {
            requestPayload.put("appCode", appCode);
        }
        Map<String, Object> map = new HashMap<>(3);
        Map<String, Object> paramMap = new HashMap<>(1);
        paramMap.put("bindUser", true);
        map.put("params", paramMap);
        map.put("pageSize", 999);
        map.put("pageNum", 1);
        requestPayload.put("eocParams", map);
        return getDigiwinAtmcReassignUsers(iamUserToken, locale, tenantId, url, responseType, requestPayload);
    }

    private List<DigiwinAtmcReassignUser> getDigiwinAtmcReassignUsers(String iamUserToken, String locale, String tenantId, String url, ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>> responseType, Map<String, Object> requestPayload) {
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(requestPayload), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                Objects.requireNonNull(responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    @Override
    public Boolean reassignSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/reassign";
        ResponseEntity<Map> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), Map.class);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException((String) responseEntity.getBody().get("errorMessage"));
        }
        return statusCode.is2xxSuccessful();
    }

    @Override
    public Boolean insertTaskPinning(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/taskPinning/insert";
        ResponseEntity<Map> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), Map.class);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException((String) responseEntity.getBody().get("errorMessage"));
        }
        return statusCode.is2xxSuccessful();
    }

    @Override
    public Boolean intelligentMaterialInspectionProject(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/action/submit";
        ResponseEntity<Map> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), Map.class);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException((String) responseEntity.getBody().get("errorMessage"));
        }
        return statusCode.is2xxSuccessful();
    }

    @Override
    public List<Map<String, Object>> conditionQueryInBi(String iamUserToken, String tenantId, String locale, String activityCode) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/bi/condition/query/" + activityCode;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<DigiwinAtmcProjectGroup> getDepartProjectGroup(String iamUserToken, String tenantId, String locale, String groupType) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/mobile/depart/project/group";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProjectGroup>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProjectGroup>>>() {
        };
        Map<String, Object> params = new HashMap<>(1);
        if (!StringUtils.hasLength(groupType)) {
            groupType = "teamMember";
        }
        params.put("groupType", groupType);
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcProjectGroup>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<DigiwinAtmcBacklogGroup> getDepartBacklogGroup(String iamUserToken, String tenantId, String locale, String groupType) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/mobile/depart/backlog/group";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklogGroup>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklogGroup>>>() {
        };
        Map<String, Object> params = new HashMap<>(1);
        if (!StringUtils.hasLength(groupType)) {
            groupType = "code";
        }
        params.put("groupType", groupType);
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklogGroup>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<DigiwinAtmcBacklog> getDepartBacklogGroupList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/mobile/depart/backlog/group/list";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<DigiwinAtmcProject> getDepartProjectGroupList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/task/mobile/depart/project/group/list";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcProject>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public String getAbiDataCache(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/bi/data/cache";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, String>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, String>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, String>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
                || responseEntity.getBody().getResponse().get("hashCode") == null
        ) {
            return "";
        }
        return responseEntity.getBody().getResponse().get("hashCode");
    }

    @Override
    public Boolean deleteAbiCondition(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/bi/condition/delete";
        ResponseEntity<Map> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), Map.class);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> saveAbiCondition(String iamUserToken, String tenantId, String locale, Map<String, Object> params, String conditionName) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/bi/condition/save";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful() || responseEntity.getBody() == null) {
            return Collections.emptyMap();
        }
        List<Map<String, Object>> responses = responseEntity.getBody().getResponse();
        for (Map<String, Object> response : responses) {
            if (conditionName.equals(response.get("conditionName"))) {
                return response;
            }
        }

        return Collections.emptyMap();
    }

    @Override
    public DigiwinAtmcActivityData getProjectData(String taskId, PcUiBotExecuteContext executeContext) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/action/show/" + taskId + "/" + executeContext.getTmActivityId();

        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcActivityData>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcActivityData>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcActivityData>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getAuthoredUser().getTenantId()), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public DigiwinAtmcActivityData getTaskData(String backlogId, PcUiBotExecuteContext executeContext) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/action/edit/" + backlogId + "?isHistory=" + executeContext.getIsHistory();

        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcActivityData>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcActivityData>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcActivityData>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getAuthoredUser().getTenantId()), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public DigiwinAtmcWorkflowProgressHistory getApprovalWorkflowHistory(String locale, String iamUserToken,
                                                                         String tenantId, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/approval/workflowHistory";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcWorkflowProgressHistory>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcWorkflowProgressHistory>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcWorkflowProgressHistory>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Boolean backlogImportance(String backlogId, String locale, String iamUserToken, String tenantId, String importanceValue) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/" + backlogId + "/importance/" + importanceValue;

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(Collections.emptyMap()), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean cancelPinning(String locale, String iamUserToken, String tenantId, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/taskPinning/cancelPinning";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getBacklogRuleDisplay(String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/rule/display";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyMap();
    }

    @Override
    public DigiwinAtmcDomain domainSearch(String locale, String iamUserToken, String tenantId, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/domain/search";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcDomain>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcDomain>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcDomain>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new DigiwinAtmcDomain();
    }

    @Override
    public List<DigiwinAtmcBacklog> getBacklogListByIds(String locale, String iamUserToken, String tenantId, List<String> backlogIdList) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/list/byIds";

        Map<String, Object> params = new HashMap<>(1);
        params.put("backlogIds", backlogIdList);
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcBacklog>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAtmcOrderSetting> getOrderTaskSetting(String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/setting/order/task";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcOrderSetting>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcOrderSetting>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcOrderSetting>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        Collections.emptyMap(), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAtmcFilterSetting> getFilterTaskSetting(String locale, String iamUserToken,
                                                               String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/backlog/setting/filter/task";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcFilterSetting>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcFilterSetting>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcFilterSetting>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        Collections.emptyMap(), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public List<DigiwinAtmcPrintTemplate> getPrintList(DigiwinAthenaApiRequest athenaApiRequest) {
        String str = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/print/list?";
        StringBuilder urlSbuilder = new StringBuilder(str);

        Map<String, String> uriVariables = athenaApiRequest.getUriVariables();
        if (!CollectionUtils.isEmpty(uriVariables)) {
            for (String uriVarKey : uriVariables.keySet()) {
                urlSbuilder.append(uriVarKey).append("=").append(uriVariables.get(uriVarKey)).append("&");
            }
        }
        String url = urlSbuilder.substring(0, urlSbuilder.length() - 1);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPrintTemplateResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPrintTemplateResult>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcPrintTemplateResult>> responseEntity =
                this.httpService.doGet(url, athenaApiRequest.getRequestHead(), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new ArrayList<>();
        }
        return responseEntity.getBody().getResponse().getTemplateList();
    }

    @Override
    public DigiwinAtmcPrintAbiData getPrintAbiData(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/print/label";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPrintAbiData>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAtmcPrintAbiData>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAtmcPrintAbiData>> responseEntity =
                this.httpService.doPost(url, athenaApiRequest.getRequestHead(),
                        JsonUtil.javaObjectToJsonString(athenaApiRequest.getBodyPayloadMap()), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<List<DigiwinAtmcTaskDebugger>> getTaskDebugger(String locale, String iamUserToken, String tenantId, Long workitemId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + DigiwinAtmcProxyService.API_PREFIX
                + "/debugger/task/" + workitemId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<List<DigiwinAtmcTaskDebugger>>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<List<DigiwinAtmcTaskDebugger>>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<List<DigiwinAtmcTaskDebugger>>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        Collections.emptyMap(), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }
}