package com.digiwin.mobile.mobileuibot.proxy.audc.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author xujinc
 */
@Data
public class DigiwinAtmcGroupRecord implements Serializable {
    private static final long serialVersionUID = -6994764473853184511L;

    // 业务分组名
    private String name;

    // 应用名称
    private String appName;

    private String code;

    // system：系统分组标签，businessKey：自定义分组标签
    private String type;

    private Boolean enabled;

    private Boolean defaultEffective;

    private Map<String, Object> lang;

    // 团队项目中按项目时间分组 使用
    // {
    //    "time": [
    //        "begin",
    //        "end"
    //    ],
    //    "date": [
    //        "month",
    //        "year"
    //    ]
    //}
    private Config configs;

    @Data
    public static class Config {
        private List<String> time;
        private List<String> date;
    }
}
