package com.digiwin.mobile.mobileuibot.proxy.audc.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
public class DigiwinAudcUserTrack implements Serializable {

    //客户端ID
    private String clientId;

    //客户端登录sessionId ，登录时随机生成UUID，持久保存，APP退出时删除
    private String sessionId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 用户组织信息
     */
    private List<UserOrgDTO> orgs;

    /**
     * 员工信息，包含部门、职能等信息
     */
    private EmpInfoDTO empInfo;

    /**
     * 操作时间点，时间戳
     */
    private Long timestamp;

    /**
     * 执行的操作，如：打开查看：OPEN，提交：SUBMIT
     */
    private String operation;

    /**
     * 作业类型，如：任务 task， 项目：Project，报表：report，基础资料录入：base-data
     */
    private String workType;

    /**
     * 作业pattern，如：任务：BUSINESS
     */
    private String workPattern;

    /**
     * 作业类别，如：基础资料录入-单档类型：SIGN-DOCUMENT
     */
    private String workCategory;

    /**
     * 作业ThemeMap定义的code，如：基础资料录入-客户建立：baseDataEntry_clients
     */
    private String workCode;

    /**
     * 作业内容，如：id、startTime、endTime
     */
    private Map<String, Object> workContent;

    /**
     * 附加信息
     */
    private Map<String, Object> attachData;
}
