package com.digiwin.mobile.mobileuibot.proxy.audc.model;

import java.util.Objects;

/**
 * <p>功能描述：运行环境类型枚举类</p>
 *
 * @FileName: ModuleSortConfigTypeEnum
 * @Author: xujinc
 * @Date: 2024/4/16 16:29
 */
public enum ModuleSortConfigTypeEnum {
    /**
     * 业务标签
     */
    LABEL("label", "业务标签"),

    /**
     * 业务标签优先
     */
    LABEL_FRONT("setLabelFront", "业务标签优先"),

    /**
     * 阅读状态
     */
    READ_STATUS("readStatus", "阅读状态"),

    /**
     * 未读优先
     */
    READ_STATUS_IS_UNREAD("readStatusUnread", "未读优先"),

    /**
     * 已读优先
     */
    READ_STATUS_IS_READ("readStatusRead", "已读优先"),

    /**
     * 任务时间
     */
    TIME("time", "任务时间"),

    /**
     * 按完成时间升序
     */
    TIME_BY_ASC("timeEndTimeAsc", "按完成时间升序"),

    /**
     * 按完成时间降序
     */
    TIME_BY_DESC("timeEndTimeDesc", "按完成时间降序"),

    /**
     * 任务类型
     */
    TASK_TYPE("taskType", "任务类型"),

    /**
     * 任务类型优先
     */
    TASK_TYPE_FRONT("taskTypeFront", "任务类型优先");

    private String type;

    private String name;

    ModuleSortConfigTypeEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(String type){
        for (ModuleSortConfigTypeEnum moduleSortConfigTypeEnum : ModuleSortConfigTypeEnum.values()) {
            if (Objects.equals(moduleSortConfigTypeEnum.getType(), type)) {
                return moduleSortConfigTypeEnum.getName();
            }
        }
        return null;
    }
}
