package com.digiwin.mobile.mobileuibot.proxy.audc.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAtmcGroupRecord;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcActivityAccessible;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcUserTrack;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcWorkbench;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotUserDefinedCenterMetadataResult;

import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @date 20220407
 */
public interface DigiwinAudcProxyService {

    String API_PREFIX = "/api/audc/v1";
    String AMTC_API_PREFIX = "/api/amtc/v1";

    String VISIT_API_PREFIX = "/api/visit";

    String USER_API_PREFIX = "/api/v1/user/track";

    /**
     * 查看可发起项目列表权限、查看报表权限
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param tmActivityIdList
     * @param category         查可发起项目时为2，查报表时为1
     * @param type             查可发起项目时为"start-project"，查报表时为report
     * @return
     */
    List<DigiwinAudcActivityAccessible> getAccessibleList(String locale, String iamUserToken, String tenantId, List<String> tmActivityIdList, int category, String type);

    /**
     * 获取所有报表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<DigiwinAtmcTmData> getTmDataList(String clientId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取所有基础资料录入表单
     *
     * @param clientId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<DigiwinAtmcTmData> getBasicDataList(String clientId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取工作台列表
     *
     * @param clientId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    DigiwinAudcWorkbench getWorkbenchList(String clientId, String iamUserToken, String tenantId, String locale);

    /**
     * 根据当前用户信息，获取保存的顺序tag
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param pageCode
     * @param tmProjectId
     * @param tmActivityId
     * @return
     */
    JSONObject getOrderConditionsByUser(String locale, String iamUserToken, String tenantId,
                                        String pageCode, String tmProjectId, String tmActivityId);

    /**
     * 根据当前用户信息，获取保存的顺序tag
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param pageCode
     * @param tmProjectId
     * @param tmActivityId
     * @return
     */
    List<PcUiBotUserDefinedCenterMetadataResult> getFieldsSeqByUser(String locale, String iamUserToken, String tenantId,
                                                                    String pageCode, String tmProjectId, String tmActivityId);

    /**
     * 获取分组信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<DigiwinAtmcGroupRecord> getGroupRecord(String locale, String iamUserToken, String tenantId);

    /**
     * 获取分组信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param pageFilterCode
     * @return
     * @see com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum
     */
    List<DigiwinAtmcGroupRecord> groupRecord(String locale, String iamUserToken, String tenantId, String pageFilterCode);

    /**
     * 保存分组信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param groupKey
     * @param groupName
     * @return
     */
    boolean saveSwitchGroupRecord(String locale, String iamUserToken, String tenantId, String groupKey, String groupName);

    /**
     * 获取module信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param moduleNo
     * @return
     */
    Map<String, Object> getModuleInfo(String locale, String iamUserToken, String tenantId, String moduleNo);

    /**
     * 保存module信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param moduleInfo
     * @return
     */
    boolean saveModuleInfo(String locale, String iamUserToken, String tenantId, Map<String, Object> moduleInfo);

    boolean saveUserTrack(List<DigiwinAudcUserTrack> digiwinAudcUserTrack, String locale, String iamUserToken, String tenantId);
}
