package com.digiwin.mobile.mobileuibot.proxy.audc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAtmcGroupRecord;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcActivityAccessible;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcUserTrack;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcWorkbench;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotUserDefinedCenterMetadataResult;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author wuyang
 * @date 20220407
 */
@Service("digiwinAudcProxyService")
public class DigiwinAudcProxyServiceImpl implements DigiwinAudcProxyService {

    private static final Logger log = LoggerFactory.getLogger(DigiwinAudcProxyServiceImpl.class);
    @Autowired
    private HttpService httpService;

    @Override
    public List<DigiwinAudcActivityAccessible> getAccessibleList(String locale, String iamUserToken, String tenantId, List<String> tmActivityIdList, int category, String type) {
        List<DigiwinAudcActivityAccessible> projectAccessibleList = new ArrayList<>(tmActivityIdList.size());
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.API_PREFIX
                + "/check/activity/accessible";
        List<Map> bodyPayloadMapList = new ArrayList<>(1);
        Map<String, Object> bodyPayloadMap = new HashMap<>(3);
        bodyPayloadMap.put("category", category);
        bodyPayloadMap.put("type", type);
        bodyPayloadMap.put("tmActivityIdList", tmActivityIdList);
        bodyPayloadMapList.add(bodyPayloadMap);
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<Map>>> responseEntity =
                httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(bodyPayloadMapList), responseType);
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            List<Map> response = responseEntity.getBody().getResponse() == null ? null : responseEntity.getBody().getResponse();
            if (response != null && response.size() > 0) {
                List<Map<String, Object>> list = (List<Map<String, Object>>) response.get(0).get("activityAccessibleList");
                if (list != null && list.size() > 0) {
                    for (Map<String, Object> map : list) {
                        projectAccessibleList.add(JsonUtil.objectToJavaObject(map, DigiwinAudcActivityAccessible.class));
                    }
                }
            }
        }
        return projectAccessibleList;
    }

    @Override
    public List<DigiwinAtmcTmData> getTmDataList(String clientId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.AMTC_API_PREFIX
                + "/commonUsed/tmDataList?plat=1&pattern=MOBI-STATEMENT";
        return getDataList(url, clientId, iamUserToken, tenantId, locale);
    }

    @Override
    public List<DigiwinAtmcTmData> getBasicDataList(String clientId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.AMTC_API_PREFIX
                + "/commonUsed/tmDataList?plat=0";
        return getDataList(url, clientId, iamUserToken, tenantId, locale);
    }

    private List<DigiwinAtmcTmData> getDataList(String url, String clientId, String iamUserToken, String tenantId, String locale) {
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTmData>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcTmData>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcTmData>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new ArrayList<>();
    }

    @Override
    public DigiwinAudcWorkbench getWorkbenchList(String clientId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.API_PREFIX
                + "/workbench/list";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAudcWorkbench>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAudcWorkbench>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAudcWorkbench>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : null;
    }

    @Override
    public JSONObject getOrderConditionsByUser(String locale, String iamUserToken, String tenantId,
                                               String pageCode, String tmProjectId, String tmActivityId) {
//        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.API_PREFIX
//                + "/userdefined/orderconditions/fields/" + pageCode + "/" + tmProjectId + "/" + tmActivityId;
//        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
//                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
//                };
//        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
//                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
//
//        HttpStatus statusCode = responseEntity.getStatusCode();
//        return statusCode.is2xxSuccessful() ?
//                responseEntity.getBody().getResponse() : null;
        return null;
    }

    @Override
    public List<PcUiBotUserDefinedCenterMetadataResult> getFieldsSeqByUser(String locale, String iamUserToken, String tenantId,
                                                                           String pageCode, String tmProjectId, String tmActivityId) {
//        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.API_PREFIX
//                + "/userdefined/fieldlist/" + pageCode + "/" + tmProjectId + "/" + tmActivityId;
//        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<PcUiBotUserDefinedCenterMetadataResult>>> responseType =
//                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<PcUiBotUserDefinedCenterMetadataResult>>>() {
//                };
//        ResponseEntity<DigiwinAthenaApiResponse<List<PcUiBotUserDefinedCenterMetadataResult>>> responseEntity =
//                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), responseType);
//
//        HttpStatus statusCode = responseEntity.getStatusCode();
//        return statusCode.is2xxSuccessful() ?
//                responseEntity.getBody().getResponse() : null;
        return null;
    }

    @Override
    public List<DigiwinAtmcGroupRecord> getGroupRecord(String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.AMTC_API_PREFIX
                + "/commonUsed/getGroupRecord";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcGroupRecord>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcGroupRecord>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAtmcGroupRecord>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform",
                                locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<DigiwinAtmcGroupRecord> groupRecord(String locale, String iamUserToken, String tenantId, String pageFilterCode) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.AMTC_API_PREFIX
                + "/commonUsed/groupRecord/" + pageFilterCode;

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform",
                                locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()
                || responseEntity.getBody() == null
                || responseEntity.getBody().getResponse() == null
                || responseEntity.getBody().getResponse().get("options") == null
        ) {
            return Collections.emptyList();
        }
        return JsonUtil.objectToJavaObject(responseEntity.getBody().getResponse().get("options"), new TypeReference<List<DigiwinAtmcGroupRecord>>() {
        });
    }

    @Override
    public boolean saveSwitchGroupRecord(String locale, String iamUserToken, String tenantId, String groupKey, String groupName) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.AMTC_API_PREFIX
                + "/commonUsed/saveSwitchGroupRecord";
        Map<String, Object> bodyPayloadMap = new HashMap<>(2);
        bodyPayloadMap.put("groupKey", groupKey);
        bodyPayloadMap.put("groupName", groupName);
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(bodyPayloadMap), responseType);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return false;
        }
        return Integer.valueOf("200").equals(responseEntity.getBody().getStatus());
    }

    @Override
    public Map<String, Object> getModuleInfo(String locale, String iamUserToken, String tenantId, String moduleNo) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.VISIT_API_PREFIX
                + "/query?moduleNo=" + moduleNo;

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType
                = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
        };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform",
                                locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyMap();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public boolean saveModuleInfo(String locale, String iamUserToken, String tenantId, Map<String, Object> moduleInfo) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.VISIT_API_PREFIX
                + "/submit";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };
        ResponseEntity<Map> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(moduleInfo), Map.class);

        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return false;
        }
        return Integer.valueOf("200").equals(responseEntity.getBody().get("status"));
    }

    @Override
    public boolean saveUserTrack(List<DigiwinAudcUserTrack> digiwinAudcUserTrack, String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAudcUrl() + DigiwinAudcProxyService.USER_API_PREFIX + "/report";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        log.debug("saveUserTrack#pre:locale:{},iamUserToken:{},tenantId:{},digiwinAudcUserTrack:{}", locale, iamUserToken, tenantId, JsonUtil.javaObjectToJsonString(digiwinAudcUserTrack));
        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(digiwinAudcUserTrack), responseType);
        log.debug("saveUserTrack#post:responseEntity:{}", responseEntity);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return false;
        }
        return Integer.valueOf("200").equals(responseEntity.getBody().getStatus());
    }
}
