package com.digiwin.mobile.mobileuibot.proxy.bi.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportSyncExport;
import com.digiwin.mobile.mobileuibot.proxy.bi.model.DigiwinBiUrl;
import com.digiwin.mobile.mobileuibot.proxy.bi.service.DigiwinBiProxyService;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;

@Service("digiwinBiProxyService")
public class DigiwinBiProxyServiceImpl implements DigiwinBiProxyService {

    private final HttpService httpService;

    public DigiwinBiProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public DigiwinBiUrl getExportAbiUrlSync(String iamUserToken, String tenantId, String locale, String reportKey, AbiReportSyncExport export) {
        String url = AppContext.getApiUrlSetting().getBiUrl() + DigiwinBiProxyService.API_PREFIX
                + "/ebibase/forwardapi/export.do?@routerKey={0}&@ReportKey={1}";
        String formatUrl = MessageFormat.format(url, tenantId, reportKey);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinBiUrl> responseType = new ParameterizedTypeReference<DigiwinBiUrl>() {
        };
        ResponseEntity<DigiwinBiUrl> responseEntity =
                httpService.doPost(formatUrl, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(export), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity.getBody();
        }
        return null;
    }
}
