package com.digiwin.mobile.mobileuibot.proxy.bpm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.bpm.model.DigiwinBpmRedoTask;
import com.digiwin.mobile.mobileuibot.proxy.bpm.service.DigiwinBpmProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinBpmProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/5/25 15:17
 */
@Service("digiwinBpmProxyService")
public class DigiwinBpmProxyServiceImpl implements DigiwinBpmProxyService {

    private static final Logger logger = LoggerFactory.getLogger(DigiwinBpmProxyServiceImpl.class);

    @Autowired
    private HttpService httpService;

    @Override
    public List<DigiwinBpmRedoTask> getRedoList(String locale, String iamUserToken,
                                                Map<String, Object> requestData) {
        String url = AppContext.getApiUrlSetting().getBpmUrl() + DigiwinBpmProxyService.API_PREFIX
                + "/process-engine/workitems/get-re-do-list";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(requestData), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                JSONArray.parseArray(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse().get("taskList")), DigiwinBpmRedoTask.class) : Collections.emptyList();
    }
}
