package com.digiwin.mobile.mobileuibot.proxy.cac.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 敏捷数据流量控制
 *
 * @author yanfeng
 * @date 2024/7/24
 */
@Data
public class DigiwinCacApplicationAuthorizationInformation implements Serializable {

    private static final long serialVersionUID = -2334339553746575594L;

    /**
     * 购买ID
     */
    private String purchaseId;

    /**
     * 客户ID
     */
    private String customerId;

    /**
     * 租户ID
     */
    private String tenantId;

    private String id;

    /**
     * 应用ID
     */
    private String code;

    /**
     * 项目ID
     */
    private String itemId;

    /**
     * 类别ID
     */
    private String categoryId;

    /**
     * 应用名称
     */
    private String displayName;

    /**
     * 应用版本
     */
    private String version;

    /**
     * 最后销售方案ID
     */
    private String lastStrategyId;


    /**
     * 生效时间
     */
    private String effectiveTime;

    /**
     * 是否授权开启
     */
    private Boolean authOpen;

    /**
     * 过期时间
     */
    private String expiredTime;

    /**
     * 是否已过期
     */
    private Boolean expired;

    /**
     * 是否缓冲期
     */
    private Boolean bufferPeriod;

    /**
     * 备注
     */
    private String memo;

    /**
     * 是否多次登录
     */
    private Boolean multiLogin;

    /**
     * 售卖类型
     */
    private int paymentType;

    /**
     * 总用户数
     */
    private int totalUserCount;

    /**
     * 授权的用户数量
     */
    private int userCount;

    /**
     * 总使用量
     */
    private Integer totalUsage;

    /**
     * 剩余使用量
     */
    private Integer remainingUsage;

    /**
     * 已使用量
     */
    private Integer quantityUsage;

    /**
     * 自定义单位
     */
    private String customUnit;

    /**
     * 计数设置
     */
    private List<CountSettings> countSettings;

    /**
     * 启用模块
     */
    private List<EnabledModules> enabledModules;

    /**
     * 初始化
     */
    private int initialize;

    /**
     * 月使用量
     */
    private int monthlyUsage;

    /**
     * 是否月计费
     */
    private Boolean monthlyPlan;

    @Data
    public static class CountSettings {
        /**
         * 计数ID
         */
        private String countingId;

        /**
         * 计数类型
         */
        private String type;

        /**
         * 已使用次数
         */
        private int usedCount;

        /**
         * 受影响的项目
         */
        private List<Affected> affected;

        /**
         * 参数
         */
        private Argument argument;

        @Data
        public static class Affected {
            /**
             * 受影响的类型
             */
            private String type;

            /**
             * 受影响的ID
             */
            private String id;
        }

        @Data
        public static class Argument {
            /**
             * 计数上限
             */
            private String countbound;

            /**
             * 令牌上限
             */
            private String tokenbound;
        }
    }

    @Data
    public static class EnabledModules {

        /**
         * 模块ID
         */
        private String id;

        /**
         * 模块名称
         */
        private String name;

        /**
         * 总使用量
         */
        private int totalUsage;

        /**
         * 剩余使用量
         */
        private int remainingUsage;

        /**
         * 生效时间
         */
        private String effectiveTime;

        /**
         * 过期时间
         */
        private String expiredTime;
    }
}