package com.digiwin.mobile.mobileuibot.proxy.cac.service;

import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacCurrentUserApp;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorizationResponse;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷CAC授权系统代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinCacProxyService
 * @Author: Zaregoto
 * @Date: 2021/11/22 1:19
 */
public interface DigiwinCacProxyService {

    String API_PREFIX = "/api/cac/v4";

    /**
     * 查询特定租户下的应用授权明细，包含应用、模组、授权时间、是否过期等明细
     *
     * @param tenantId  租户ID
     * @param userToken IAM的用户token
     * @return 租户下的应用授权明细响应对象
     */
    DigiwinCacTenantAuthorizationResponse findTenantAuthorizations(String tenantId, String userToken);

    /**
     * 获取指定租户内的用户可使用的商品清单
     *
     * @param tenantId  租户ID
     * @param userId    账号ID
     * @param userToken IAM的用户token
     * @return 云应用ID/商品code的List集合
     */
    List<String> findAuthorizationsEnabledByUserIdAndTenantId(String tenantId, String userId, String userToken);

    /**
     * 判断指定租户、用户是否可以使用应用模組
     *
     * @param tenantId  租户ID
     * @param userId    账号ID
     * @param goodsCode 云应用ID/商品code
     * @param moduleId  模组ID
     * @param userToken IAM的用户token
     * @return true-可用，false-不可用
     */
    Boolean useModuleByTenantIdAndUserId(String tenantId, String userId, String goodsCode, String moduleId, String userToken);

    /**
     * 查询当前登录用户可用的应用清单信息【4.28】【4.31】
     * 当前用户是否有应用权限
     *
     * @param userId
     * @param userToken
     * @return
     * @link <a href="http://172.16.2.141:22694/html/web/controller/share/share.html#64effe967c5ba91dcd99c091">...</a>
     */
    List<DigiwinCacCurrentUserApp> findAuthorizationsCurrentUserApp(String userId, String userToken);

    /**
     * 获取购买过的应用
     *
     * @param iamUserToken
     * @return
     */
    Map<String, Object> getAuthorizationsCurrentSimple(String iamUserToken);

    /**
     * 授权用户使用商品
     *
     * @param countingId 商品计数id
     * @param tenantId   要被授权的租户id
     * @param userId     要被授权的账号id
     * @return
     */
    Boolean countingUserAdd(String countingId, String tenantId, String userId);

}