package com.digiwin.mobile.mobileuibot.proxy.cac.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacCurrentUserApp;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacResponse;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorizationResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinCacProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/11/22 1:21
 */
@Slf4j
@Service("digiwinCacProxyService")
public class DigiwinCacProxyServiceImpl implements DigiwinCacProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public DigiwinCacTenantAuthorizationResponse findTenantAuthorizations(
            String tenantId, String userToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl()
                + DigiwinCacProxyService.API_PREFIX + "/authorizations/tenants/{tenantId}";

        Map<String, String> uriVariables = new HashMap<>(1);
        uriVariables.put("tenantId", tenantId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinCacTenantAuthorizationResponse> responseType =
                new ParameterizedTypeReference<DigiwinCacTenantAuthorizationResponse>() {
                };

        ResponseEntity<DigiwinCacTenantAuthorizationResponse> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), uriVariables, responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody() : DigiwinCacTenantAuthorizationResponse.createEmpty();
    }

    @Override
    public List<String> findAuthorizationsEnabledByUserIdAndTenantId(String tenantId, String userId,
                                                                     String userToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl()
                + DigiwinCacProxyService.API_PREFIX + "/authorizations/tenants/" +
                tenantId + "/users/" + userId + "/enabled";
        ParameterizedTypeReference<List<String>> responseType =
                new ParameterizedTypeReference<List<String>>() {
                };
        ResponseEntity<List<String>> responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), responseType);
        return responseEntity.getStatusCode().is2xxSuccessful() ? responseEntity.getBody() : new ArrayList<>();
    }

    @Override
    public Boolean useModuleByTenantIdAndUserId(String tenantId, String userId, String goodsCode, String moduleId, String userToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl()
                + DigiwinCacProxyService.API_PREFIX + "/authorizations/tenants/" +
                tenantId + "/users/" + userId + "/goods/" + goodsCode + "/module/" + moduleId;
        ParameterizedTypeReference<Map<String, Boolean>> responseType =
                new ParameterizedTypeReference<Map<String, Boolean>>() {
                };
        ResponseEntity<Map<String, Boolean>> responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), responseType);
        return responseEntity.getStatusCode().is2xxSuccessful() ? responseEntity.getBody().get("isSuccess") : false;
    }

    @Override
    public List<DigiwinCacCurrentUserApp> findAuthorizationsCurrentUserApp(String userId, String userToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl()
                + DigiwinCacProxyService.API_PREFIX + "/authorizations/current/user/apps";
        ParameterizedTypeReference<DigiwinCacResponse<List<DigiwinCacCurrentUserApp>>> responseType =
                new ParameterizedTypeReference<DigiwinCacResponse<List<DigiwinCacCurrentUserApp>>>() {
                };
        ResponseEntity<DigiwinCacResponse<List<DigiwinCacCurrentUserApp>>> responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), responseType);
        return responseEntity.getStatusCode().is2xxSuccessful() ? Objects.requireNonNull(responseEntity.getBody()).getData() : new ArrayList<>();
    }

    @Override
    public Map<String, Object> getAuthorizationsCurrentSimple(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl()
                + DigiwinCacProxyService.API_PREFIX + "/authorizations/current/simple";

        Map<String, Object> bodyPayLoad = new HashMap<>(2);
        bodyPayLoad.put("queryExpire", 0);

        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(bodyPayLoad), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && ObjectUtils.isNotEmpty(responseEntity.getBody()) ?
                responseEntity.getBody() : Collections.emptyMap();
    }

    @Override
    public Boolean countingUserAdd(String countingId, String tenantId, String userId) {
        String url = AppContext.getApiUrlSetting().getCacUrl() + DigiwinCacProxyService.API_PREFIX + "/counting/user/add";

        Map<String, Object> bodyPayLoad = new HashMap<>(3);
        bodyPayLoad.put("countingId", countingId);
        bodyPayLoad.put("tenantId", tenantId);
        bodyPayLoad.put("userId", userId);

        ResponseEntity<JSONObject> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                        JsonUtil.javaObjectToJsonString(bodyPayLoad), JSONObject.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        /**
         * {"totalCount":-1,"currentCount":254,"argument":{},"isSuccess":true}
         */
        return statusCode.is2xxSuccessful() && responseEntity.getBody().getBoolean("isSuccess");
    }

}