package com.digiwin.mobile.mobileuibot.proxy.cam.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能: 钉钉集成应用信息映射返回类
 *
 * @author: yanfeng
 * @date: 2023/09/20
 */
@Data
public class DigiwinCamDingDingMapperResult implements Serializable {
    private static final long serialVersionUID = -3766156822530391446L;
    /**
     * 平台类型，1-上汽平台,3-钉钉平台
     *
     * @see DigiwinCamDingDingMapperEnum
     */
    private Integer platform;

    private List<MapperData> datas;

    @Data
    public static class MapperData {
        /**
         * 属性id，appId-第三方应用id，clientKey-第三方应用clientKey,clientSecret-第三方应用Secret
         */
        private String key;
        /**
         * 属性名称
         */
        private String name;
        /**
         * 属性值
         */
        private String value;
    }
}
