package com.digiwin.mobile.mobileuibot.proxy.cam.service;

import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigIwinCamResponse;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigiwinCamDingDingMapperResult;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigiwinCamDingDingQuery;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigiwinCamDingDingResult;

import java.util.List;
import java.util.Map;

public interface DigIwinCamProxyService {

    String API_PREFIX = "/api/cam/v1";


    /**
     * CAM集成钉钉SSO登录
     *
     * @param query 鼎捷云应用Id
     * @return DigiwinIamDingDingResultData
     * @author yanfeng
     * @link <a href="https://console-docs.apipost.cn/preview/e7358d62fa5809f7/97ecc6524d3aabb9?target_id=46930876-cee8-4bbe-a666-41d9cfd2f932">...</a>
     */
    DigiwinCamDingDingResult dingDingSsoLogin(DigiwinCamDingDingQuery query);


    /**
     * 钉钉集成应用信息
     *
     * @param appId 鼎捷云应用Id
     * @return DigiwinCamDingDingMapperResult
     * @author yanfeng
     * @link <a href="http://172.16.2.141:22694/html/web/controller/share/share.html#650bdaad5ab55a4e439efd1d">...</a>
     */
    List<DigiwinCamDingDingMapperResult.MapperData> getGoodsMappings(String appId);

    /**
     * line 自动登录
     *
     * @param params
     * @return
     */
    DigIwinCamResponse getLineCamInfo(Map<String, Object> params);


}
